/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file Tools.h
 *
 * @author Ronny Stricker
 * @date   2011/09/18
 */
#ifndef _MIRA_TOOLS_H_
#define _MIRA_TOOLS_H_

#include <string>

#include <utils/Path.h>
#include <utils/Singleton.h>


namespace mira {

/**
 * @brief Class to keep track if a QApplication exists
 * Basically this is a work around to check if a QApplication exists or not.
 */
class QAppExist : public LazySingleton<QAppExist>
{
public:

	QAppExist();

	static bool get();

	static void set( bool value );

private:
	bool mAppExist;
};

/**
 * @brief simple wrapper for convenient access to the MIRA Path variable.
 */
class PathProvider : public LazySingleton<PathProvider> {
public:

	/**
	 * @brief try to obtain and store MIRA_PATH environment variable
	 */
	PathProvider();

	/**
	 * @brief return MIRA_PATH variable.
	 */
	static PathVector miraPaths();
	
	/**
	 * @brief return the MIRA_PATH variable which is contained in the given path.
	 * Tries to match the beginning of the given path with every MIRA_PATH variable.
	 * Returns an empty path if no match can be found.
	 */
	static mira::Path getAssociatedMiraPath( mira::Path const& path );
	
	/**
	 * @brief calls getAssociatedMiraPath and returns true if a match was found.
	 */
	static bool isMiraSubPath( mira::Path const& path );
	
	mira::PathVector mMiraPaths;
};

}

#endif /* _MIRA_TOOLS_H_ */
