/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file ConfigurationEditor.h
 *    Allows to edit the current configuration and adding new units
 *
 * @author Tim Langner, Erik Einhorn, Christof Schröter
 * @date   2011/12/08
 */

// include the view base class
#include <rcp/EditorPart.h>

class QCheckBox;
class QComboBox;
class QPlainTextEdit;
class QPushButton;
class QWidget;

namespace mira { 

///////////////////////////////////////////////////////////////////////////////

/**
 * Allows to edit the current configuration and adding new units
 */
class ConfigurationEditor : public mira::EditorPart
{
Q_OBJECT
MIRA_META_OBJECT(ConfigurationEditor,
                ("Name", "Configuration Editor")
                ("Description", "Allows to edit the current configuration and adding new units"))

public:

	ConfigurationEditor();

protected:

	virtual QWidget* createPartControl();
	virtual void timerEvent(QTimerEvent* event);

private:

	void updateServicesList();
	
private slots:

	void addUnitConfig();
	void formatConfig();
	void loadConfig();

private:

	QWidget* mWidget;
	QCheckBox* mCommentsBox;
	QPlainTextEdit* mEdit;
	QWidget* mServiceWidget;
	QComboBox* mServiceBox;
	QPushButton* mLoadButton;
	int mUpdateServicesTimer;
	
	std::deque<std::string> mServices;
	bool mWaitForLocal;
};

///////////////////////////////////////////////////////////////////////////////

}
