/*
 * Copyright (C) by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file IRobotModelProvider.h
 *    Interface for robot model provider services.
 *
 * @author Christof Schröter
 * @date   2019/11/20
 */

#ifndef _MIRA_IROBOTMODELPROVIDER_H_
#define _MIRA_IROBOTMODELPROVIDER_H_

#include <fw/Framework.h>

#include <model/IRigidModelProvider.h>
#include <robot/RobotModel.h>

namespace mira { namespace robot {

///////////////////////////////////////////////////////////////////////////////

/**
 * Interface for robot model provider services
 */
class IRobotModelProvider : public virtual model::IRigidModelProvider
{
public:
	template<typename Reflector>
	void reflect(Reflector& r)
	{
		MIRA_REFLECT_BASE(r, model::IRigidModelProvider);
		r.interface("IRobotModelProvider");
		r.method("getRobotModel", &IRobotModelProvider::getRobotModel, this,
		         "Return the current robot model");
	}

	/// The destructor
	virtual ~IRobotModelProvider() {}

	/**
	 * Return the model as RobotModel pointer.
	 */
	virtual RobotModelPtr getRobotModel() = 0;

	/// Implementation IRigidModelProvider
	// This is probably the sensible definition. However, we must not implement it here, as an
	// implementation of IRobotModelProvider will want to inherit from IRobotModelProvider and an
	// IMPLEMENTATION of IRigidModelProvider, thus inheriting 2 ambiguous definitions of getRigidModel().
	// --> we need to leave it to the non-abstract subclass to define this, if required.
	//virtual model::RigidModelPtr getRigidModel() { return getRobotModel(); }
};

///////////////////////////////////////////////////////////////////////////////

}}

#endif 
