/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file DotToSvg.C
 *    .
 *
 * @author Erik Einhorn, Ronny Stricker
 * @date   2014/03/12
 */

#include <common/DotToSvg.h>

#include <platform/Process.h>
#include <error/Exceptions.h>
#include <error/Logging.h>

using namespace std;

namespace mira {

string dotToSvg( string const& dotGraph )
{
	string data;
	// we use dot to generate a svg from the dot graph description
	Process p;
	try {
		p = Process::createProcess("dot -Tsvg", Process::in | Process::out);
	} catch(XFileNotFound&) {
		MIRA_LOG(WARNING) << "Graphviz dot command not found. Please install the 'graphviz' package.";
		return data;
	} catch(Exception& ex) {
		MIRA_LOG(WARNING) << "Failed to invoke Graphviz dot: " << ex.message();
		return data;
	}

	// send the dot graph description to the stdin of the dot process
	p.cin() << dotGraph;
	p.cin().flush();
	p.cin().close();

	// read svg result from the stdout of the dot process
	char c;
	while(!p.cout().eof()) {
		p.cout().read(&c,1);
		data.append(1,c);
	}

	p.wait();

	return data;
}

///////////////////////////////////////////////////////////////////////////////

}
