#!/bin/bash

###############################################################################
# A script for updating an existing miracenter workspace file to adapt
# class names after updating toolbox CommonVisualizations
# from version <=1.3.0 to 1.4.0 (MIRA Release 2021-11-12).
###############################################################################

usage(){
	echo "Usage: $0 /path/to.workspace"
	exit 1
}
[[ $# -ne 1 ]] && usage

date=$(date '+%Y%m%dT%H%M%S')

echo Creating backup $1.bak$date
cp $1 $1.bak$date

echo Updating $1

sed -i s/\"mira::gui::AnnotationVisualization_floatAtPose2\"/\"mira::gui::AnnotationVisualization3D_floatAtPose2\"/g $1
sed -i s/\"mira::gui::AnnotationVisualization_floatAtPose3\"/\"mira::gui::AnnotationVisualization3D_floatAtPose3\"/g $1
sed -i s/\"mira::gui::AnnotationVisualization_floatAtPoseCov2\"/\"mira::gui::AnnotationVisualization3D_floatAtPoseCov2\"/g $1
sed -i s/\"mira::gui::AnnotationVisualization_floatAtPoseCov3\"/\"mira::gui::AnnotationVisualization3D_floatAtPoseCov3\"/g $1
sed -i s/\"mira::gui::AnnotationVisualization_intAtPose2\"/\"mira::gui::AnnotationVisualization3D_intAtPose2\"/g $1
sed -i s/\"mira::gui::AnnotationVisualization_intAtPose3\"/\"mira::gui::AnnotationVisualization3D_intAtPose3\"/g $1
sed -i s/\"mira::gui::AnnotationVisualization_intAtPoseCov2\"/\"mira::gui::AnnotationVisualization3D_intAtPoseCov2\"/g $1
sed -i s/\"mira::gui::AnnotationVisualization_intAtPoseCov3\"/\"mira::gui::AnnotationVisualization3D_intAtPoseCov3\"/g $1
sed -i s/\"mira::gui::AnnotationVisualization_stringAtPose2\"/\"mira::gui::AnnotationVisualization3D_stringAtPose2\"/g $1
sed -i s/\"mira::gui::AnnotationVisualization_stringAtPose3\"/\"mira::gui::AnnotationVisualization3D_stringAtPose3\"/g $1
sed -i s/\"mira::gui::AnnotationVisualization_stringAtPoseCov2\"/\"mira::gui::AnnotationVisualization3D_stringAtPoseCov2\"/g $1
sed -i s/\"mira::gui::AnnotationVisualization_stringAtPoseCov3\"/\"mira::gui::AnnotationVisualization3D_stringAtPoseCov3\"/g $1
sed -i s/\"mira::gui::AnnotationVisualization_uint32AtPose2\"/\"mira::gui::AnnotationVisualization3D_uint32AtPose2\"/g $1
sed -i s/\"mira::gui::AnnotationVisualization_uint32AtPose3\"/\"mira::gui::AnnotationVisualization3D_uint32AtPose3\"/g $1
sed -i s/\"mira::gui::AnnotationVisualization_uint32AtPoseCov2\"/\"mira::gui::AnnotationVisualization3D_uint32AtPoseCov2\"/g $1
sed -i s/\"mira::gui::AnnotationVisualization_uint32AtPoseCov3\"/\"mira::gui::AnnotationVisualization3D_uint32AtPoseCov3\"/g $1
sed -i s/\"mira::gui::BoolTextVisualization\"/\"mira::gui::BoolVisualizationText\"/g $1
sed -i s/\"mira::gui::BoxVectorVisualization\"/\"mira::gui::BoxVectorVisualization3D\"/g $1
sed -i s/\"mira::gui::BoxVisualization\"/\"mira::gui::BoxVisualization3D\"/g $1
sed -i s/\"mira::gui::DoubleTextVisualization\"/\"mira::gui::DoubleVisualizationText\"/g $1
sed -i s/\"mira::gui::FloatTextVisualization\"/\"mira::gui::FloatVisualizationText\"/g $1
sed -i s/\"mira::gui::GroundPlaneVisualization\"/\"mira::gui::GroundPlaneVisualization3D\"/g $1
sed -i s/\"mira::gui::ImgVisualization_double1\"/\"mira::gui::ImgVisualization2D_double1\"/g $1
sed -i s/\"mira::gui::ImgVisualization_float1\"/\"mira::gui::ImgVisualization2D_float1\"/g $1
sed -i s/\"mira::gui::ImgVisualization_uint161\"/\"mira::gui::ImgVisualization2D_uint161\"/g $1
sed -i s/\"mira::gui::ImgVisualization_uint81\"/\"mira::gui::ImgVisualization2D_uint81\"/g $1
sed -i s/\"mira::gui::ImgVisualization_uint83\"/\"mira::gui::ImgVisualization2D_uint83\"/g $1
sed -i s/\"mira::gui::ImgVisualization_void1\"/\"mira::gui::ImgVisualization2D_void1\"/g $1
sed -i s/\"mira::gui::Int16TextVisualization\"/\"mira::gui::Int16VisualizationText\"/g $1
sed -i s/\"mira::gui::Int32TextVisualization\"/\"mira::gui::Int32VisualizationText\"/g $1
sed -i s/\"mira::gui::Int64TextVisualization\"/\"mira::gui::Int64VisualizationText\"/g $1
sed -i s/\"mira::gui::Int8TextVisualization\"/\"mira::gui::Int8VisualizationText\"/g $1
sed -i s/\"mira::gui::MeshVisualization\"/\"mira::gui::MeshVisualization3D\"/g $1
sed -i s/\"mira::gui::PathPoint2fVisualization\"/\"mira::gui::Point2fPathVisualization3D\"/g $1
sed -i s/\"mira::gui::PathPoint3fVisualization\"/\"mira::gui::Point3fPathVisualization3D\"/g $1
sed -i s/\"mira::gui::PathPose2dVisualization\"/\"mira::gui::RigidTransform2dPathVisualization3D\"/g $1
sed -i s/\"mira::gui::PathPose2fVisualization\"/\"mira::gui::Pose2PathVisualization3D\"/g $1
sed -i s/\"mira::gui::PathPose3dVisualization\"/\"mira::gui::RigidTransform3dPathVisualization3D\"/g $1
sed -i s/\"mira::gui::PathPose3fVisualization\"/\"mira::gui::Pose3PathVisualization3D\"/g $1
sed -i s/\"mira::gui::PlaneVisualization\"/\"mira::gui::PlaneVisualization3D\"/g $1
sed -i s/\"mira::gui::Point2fVisualization\"/\"mira::gui::Point2fVisualization3D\"/g $1
sed -i s/\"mira::gui::Point2iVisualization\"/\"mira::gui::Point2iVisualization3D\"/g $1
sed -i s/\"mira::gui::Point3fVisualization\"/\"mira::gui::Point3fVisualization3D\"/g $1
sed -i s/\"mira::gui::Point3iVisualization\"/\"mira::gui::Point3iVisualization3D\"/g $1
sed -i s/\"mira::gui::PointVectorVisualization2d\"/\"mira::gui::EigenVector2dVisualization3D\"/g $1
sed -i s/\"mira::gui::PointVectorVisualization3d\"/\"mira::gui::EigenVector3dVisualization3D\"/g $1
sed -i s/\"mira::gui::PointVectorVisualizationVector2d\"/\"mira::gui::EigenVector2dVectorVisualization3D\"/g $1
sed -i s/\"mira::gui::PointVectorVisualizationVector3d\"/\"mira::gui::EigenVector3dVectorVisualization3D\"/g $1
sed -i s/\"mira::gui::Pose2CovVectorMeshVisualization\"/\"mira::gui::Pose2CovVectorMeshVisualization3D\"/g $1
sed -i s/\"mira::gui::Pose2CovVectorVisualization\"/\"mira::gui::Pose2CovVectorVisualization3D\"/g $1
sed -i s/\"mira::gui::Pose2TextVisualization\"/\"mira::gui::Pose2VisualizationText\"/g $1
sed -i s/\"mira::gui::Pose2VectorMeshVisualization\"/\"mira::gui::Pose2VectorMeshVisualization3D\"/g $1
sed -i s/\"mira::gui::Pose2VectorVisualization\"/\"mira::gui::Pose2VectorVisualization3D\"/g $1
sed -i s/\"mira::gui::Pose2Visualization\"/\"mira::gui::Pose2Visualization3D\"/g $1
sed -i s/\"mira::gui::Pose3CovVectorMeshVisualization\"/\"mira::gui::Pose3CovVectorMeshVisualization3D\"/g $1
sed -i s/\"mira::gui::Pose3CovVectorVisualization\"/\"mira::gui::Pose3CovVectorVisualization3D\"/g $1
sed -i s/\"mira::gui::Pose3TextVisualization\"/\"mira::gui::Pose3VisualizationText\"/g $1
sed -i s/\"mira::gui::Pose3VectorMeshVisualization\"/\"mira::gui::Pose3VectorMeshVisualization3D\"/g $1
sed -i s/\"mira::gui::Pose3VectorVisualization\"/\"mira::gui::Pose3VectorVisualization3D\"/g $1
sed -i s/\"mira::gui::Pose3Visualization\"/\"mira::gui::Pose3Visualization3D\"/g $1
sed -i s/\"mira::gui::PoseCov2TextVisualization\"/\"mira::gui::PoseCov2VisualizationText\"/g $1
sed -i s/\"mira::gui::PoseCov2Visualization\"/\"mira::gui::PoseCov2Visualization3D\"/g $1
sed -i s/\"mira::gui::PoseCov3TextVisualization\"/\"mira::gui::PoseCov3VisualizationText\"/g $1
sed -i s/\"mira::gui::PoseCov3Visualization\"/\"mira::gui::PoseCov3Visualization3D\"/g $1
sed -i s/\"mira::gui::RangeCircleVisualization\"/\"mira::gui::RangeCircleVisualization3D\"/g $1
sed -i s/\"mira::gui::RigidTransform2dVectorVisualization\"/\"mira::gui::RigidTransform2dVectorVisualization3D\"/g $1
sed -i s/\"mira::gui::RigidTransformCov2dVectorVisualization\"/\"mira::gui::RigidTransformCov2dVectorVisualization3D\"/g $1
sed -i s/\"mira::gui::StringTextVisualization\"/\"mira::gui::StringVisualizationText\"/g $1
sed -i s/\"mira::gui::TransformTreeVisualization\"/\"mira::gui::TransformTreeVisualization3D\"/g $1
sed -i s/\"mira::gui::UInt16TextVisualization\"/\"mira::gui::UInt16VisualizationText\"/g $1
sed -i s/\"mira::gui::UInt32TextVisualization\"/\"mira::gui::UInt32VisualizationText\"/g $1
sed -i s/\"mira::gui::UInt64TextVisualization\"/\"mira::gui::UInt64VisualizationText\"/g $1
sed -i s/\"mira::gui::UInt8TextVisualization\"/\"mira::gui::UInt8VisualizationText\"/g $1
sed -i s/\"mira::gui::Vector2dVisualization\"/\"mira::gui::Vector2dVisualization3D\"/g $1
sed -i s/\"mira::gui::Vector2fVisualization\"/\"mira::gui::Vector2fVisualization3D\"/g $1
sed -i s/\"mira::gui::Vector3dVisualization\"/\"mira::gui::Vector3dVisualization3D\"/g $1
sed -i s/\"mira::gui::Vector3fVisualization\"/\"mira::gui::Vector3fVisualization3D\"/g $1
sed -i s/\"mira::gui::VectorXdVisualization\"/\"mira::gui::VectorXdVisualization3D\"/g $1
sed -i s/\"mira::gui::VectorXfVisualization\"/\"mira::gui::VectorXfVisualization3D\"/g $1

sed -i s/\"mira::maps::PointCloudVisualizationVectorPoint2f\"/\"mira::gui::Point2fVectorVisualization3D\"/g $1
sed -i s/\"mira::maps::PointCloudVisualizationVectorPoint3f\"/\"mira::gui::Point3fVectorVisualization3D\"/g $1
sed -i s/\"mira::maps::PointCloudVisualizationVectorVector3f\"/\"mira::gui::EigenVector3fVectorVisualization3D\"/g $1

echo Done
