#!/bin/bash

function usage
{
	echo -e "\
Usage: miraedit <package>:<relative path> [options]\n\n\
Edits the specified file of a given package using a text editor.\n\n\
A proper editor is chosen as follows:\n\
 1. the editor that is set in the \$MIRA_EDITOR environment variable\n\
 2. the editor that is set in the \$EDITOR environment variable\n\
 3. 'gedit' if it exist\n\
 4. 'kate' if it exist\n\
 5. 'vi' if it exist\n\
"
}


if [[ $1 = "--help" ]] || [[ $1 = "-h" ]] || [[ $# -lt 1 ]]; then
	usage
	exit 0
fi

# search for a proper editor

if [ ! -z "$MIRA_EDITOR" ]; 
then
	editor="$MIRA_EDITOR"
elif [ ! -z "$EDITOR" ]; 
then
	editor="$EDITOR"
elif [ $(command -v gedit) ];
then
	editor="gedit"
elif [ $(command -v kate) ];
then
	editor="kate"
elif [ $(command -v vi) ];
then
	editor="vi"
fi

if [ -z "$editor" ];
then 
	echo -e "No proper editor found. Please set the \$MIRA_EDITOR or \$EDITOR environment variable."
	exit -1
fi

#import mirabash functions
DIR=$(dirname "${BASH_SOURCE[0]}")
source $DIR/../mirabash

filename=$1
if [[ $1 =~ : ]]; then
	_mira_split_path $1
	filename=${_mira_split_path_var[4]}
fi

$editor $filename ${@:2}
