###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Setting for using the CLANG compiler
#
# Author: Erik Einhorn
#
###############################################################################

set(CMAKE_CXX_STANDARD 17)
set(CMAKE_CXX_STANDARD_REQUIRED On)
set(CMAKE_CXX_EXTENSIONS Off)

# enable some important settings and warnings

# most of them are "-Wall" and "-Wextra" warnings but by specifying them separately
# we can be sure that we have the same behavior with different compiler versions
ADD_DEFINITIONS(
	-Waddress
	-Warray-bounds
	-Wchar-subscripts
	-Wcomment
	-Wdeprecated
	-Wdeprecated-declarations
	-Wformat
	-Wmain
	-Wmissing-braces
	-Wparentheses
	-Wreturn-type
	-Wsequence-point
	-Wsign-compare
	-Wstrict-aliasing
	-Wstrict-overflow=1
	-Wtrigraphs
	-Wunused-function
	-Wunused-label
	-Wunused-value
	-Wvolatile-register-var
	-Wempty-body
	-Wignored-qualifiers
	-Wmissing-field-initializers
	-Wsign-compare
	-Wtype-limits
	#-Wfloat-equal
	-Wpointer-arith
	-Wredundant-decls
	#-Winline
	-Wno-inconsistent-missing-override
	-Wno-parentheses-equality
	-Wno-unneeded-internal-declaration
	-Wno-deprecated
)


SET(COVERAGE_FLAG "")
IF(DEFINED GENERATE_COVERAGE_FILES)
	SET(COVERAGE_FLAG "--coverage")
ENDIF()

SET(ADDITIONAL_CXX_FLAGS "-Wswitch -Wreorder -Wnon-virtual-dtor")

# set additional debug flags (explicitly set optimize level to 0 and add gdb debug symbols)
SET(CMAKE_CXX_FLAGS_DEBUG   "-O0 -ggdb -DMIRA_SEVERITY_MAX_LEVEL=5 ${COVERAGE_FLAG} ${ADDITIONAL_CXX_FLAGS}" )
SET(CMAKE_CXX_FLAGS_RELEASE "-O3 -DNDEBUG -DMIRA_SEVERITY_MAX_LEVEL=3 ${ADDITIONAL_CXX_FLAGS}")
SET(CMAKE_CXX_FLAGS_RELWITHDEBINFO "-O3 -ggdb -DNDEBUG -DMIRA_SEVERITY_MAX_LEVEL=5 ${ADDITIONAL_CXX_FLAGS}")



