/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file VisualizationTextTraceView.h
 *    Implementation of Default text trace visualizations.
 *
 * @author Tim Langner, Christof Schroeter
 * @date   2014/07/22
 */

#include <QTableWidget>

#include <visualization/VisualizationTextTrace.h>

#ifndef _MIRA_VISUALIZATIONTEXTTRACEVIEW_H_
#define _MIRA_VISUALIZATIONTEXTTRACEVIEW_H_

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class VisualizationTextTraceView;

class VisualizationTextTraceItem : public QObject, public IVisualizationTextTraceItem
{
	Q_OBJECT;
public:

	VisualizationTextTraceItem(QTableWidget* t, int column,
	                           VisualizationTextTraceView* v);

public:

	void setName(const std::string& name);

	virtual void setStamped(const Time& timestamp, const std::string& frameID,
	                        uint32 sequenceID, const std::string& text);

	int column() const;

	QTableWidget* table;
	QTableWidgetItem* columnItem;
	VisualizationTextTraceView* view;
};

///////////////////////////////////////////////////////////////////////////////

class VisualizationTextTraceView_UI : public QTableWidget
{
	Q_OBJECT

public:

	VisualizationTextTraceView_UI(VisualizationTextTraceView* parent);
	virtual ~VisualizationTextTraceView_UI();

protected:

	virtual void dragEnterEvent(QDragEnterEvent *event);

	virtual void dropEvent(QDropEvent *event);

	virtual void dragMoveEvent(QDragMoveEvent* event);

	void freeze(bool freeze);

public:

	void saveAsCSV();

	std::vector<int> getColumnWidths();

public slots:

	void rowResized(int row, int oldSize, int newSize);

	void popupMenu(const QPoint& pos);

protected:

	VisualizationTextTraceView* vis;
	QString stylesheet;
};
///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
