/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file VisualizationControl.C
 *    Implementation of VisualizationControl.h.
 *
 * @author Erik Einhorn
 * @date   2010/12/17
 */

#include <views/VisualizationControl.h>

#include <QLabel>
#include <QMenu>

#include <serialization/Serialization.h>

#include <rcp/EditorPart.h>
#include <widgets/PropertyEditor.h>
#include <views/VisualizationControlPage.h>

///////////////////////////////////////////////////////////////////////////////

MIRA_CLASS_SERIALIZATION(mira::VisualizationControl, mira::PageViewPart);

namespace mira {

///////////////////////////////////////////////////////////////////////////////

VisualizationControl::VisualizationControl() : mDefaultPage(NULL)
{
	mHideFilterBarAct = getViewMenu()->addAction(tr("Hide filter bar automatically"));
	mHideFilterBarAct->setCheckable(true);
}

VisualizationControl::~VisualizationControl()
{
}

QWidget*  VisualizationControl::createPartControl()
{
	QWidget* w = PageViewPart::createPartControl();

	// get page for current editor (if it is a visualization)
	IWorkbenchPart* editor = getSite()->getActiveEditor();
	QWidget* page = NULL;
	if(editor!=NULL)
		page = createPage(editor);
	if(page!=NULL)
		setPage(page);
	return w;
}

QWidget* VisualizationControl::createDefaultPage()
{
	if(mDefaultPage==NULL) {
		QLabel* label = new QLabel(this);
		label->setAlignment(Qt::AlignCenter);
		label->setText(tr("Visualizations are not available"));
		mDefaultPage = label;
	}
	return mDefaultPage;
}

QWidget* VisualizationControl::createPage(IWorkbenchPart* part)
{
	if(part->getClass().isDerivedFrom(&EditorPart::CLASS()))
	{
		Object* obj = part->getAdapter(VisualizationControlPage::CLASS());
		if(obj==NULL) // editor does not support a visualization control, so use default page
			return createDefaultPage();

		VisualizationControlPage* page = dynamic_cast<VisualizationControlPage*>(obj);
		assert(page!=NULL);

		page->mEditor->setAutoHideFilterBar(mHideFilterBarAct->isChecked());
		connect(mHideFilterBarAct, SIGNAL(toggled(bool)),
		        page->mEditor, SLOT(setAutoHideFilterBar(bool)));

		return page;
	}

	// no editor, so do not change current page
	return NULL;
}

///////////////////////////////////////////////////////////////////////////////

}
