/*
 * BenchmarkSingleProcess.C
 *
 *  Created on: 09.07.2012
 *      Author: erik
 */



#include <stdint.h>
#include <stdlib.h>

#include <yarp/os/all.h>
#include <yarp/sig/Vector.h>
#include <iostream>

#include "../BenchmarkStats.h"

using namespace yarp::os;
using namespace yarp::sig;

int N = 0;

class Publisher /*: public Thread*/
{
public:
	Network yarp;

	void run()
	{
		BenchmarkStats b("Publisher");

		// Make two ports called /hello/in and /hello/out
		// We'll send "Bottles" (a simple nested list container) between these ports
		Port outPort;
		bool ok = outPort.open("/benchmark/out");
		if (!ok) {
			std::cout << "Failed to create ports."<< std::endl;
			return;
		}

		yarp.connect("/benchmark/out","/benchmark/in", "local");


		uint64_t memStart = getMemoryUsage();

		for(int i=0; i<200; ++i)
		{
			uint64_t start = b.tic();

			VectorOf<uint8_t> values;
			values.resize(N*1024);
			uint64_t* t = reinterpret_cast<uint64_t*>(values.getFirst());
			*t = start;
			*(t+1) = i;
			// send the message
			outPort.write(values);
			b.toc();

			uint64_t memDiff1 = getMemoryUsage() - memStart;
			std::cout << "Publisher Memory1: " << memDiff1 << std::endl;

			Time::delay(0.1);
		}
	}
};

class Subscriber : public Thread
{
public:
	void run()
	{
		BenchmarkStats b("Subscriber");

		// Make two ports called /hello/in and /hello/out
		// We'll send "Bottles" (a simple nested list container) between these ports
		BufferedPort<VectorOf<uint8_t> > inPort;
		bool ok = inPort.open("/benchmark/in");
		if (!ok) {
			std::cout << "Usage: BenchmarkPublisher Data_Size_In_KB" << std::endl;
			return;
		}

		for(int i=0; i<200; ++i)
		{
			// read the message
			VectorOf<uint8_t> *data = inPort.read(true);
			if (data==NULL) {
				std::cout << "Failed to read message" << std::endl;
				Time::delay(0.1);
				continue;
			}

			uint64_t* t = reinterpret_cast<uint64_t*>(data->getFirst());
			b.toc(*t);
			//std::cout << *(t+1) << std::endl;
			//std::cout << data->size() << std::endl;;

		}
	}
};

int main(int argc, char *argv[])
{
	if(argc<2) {
		std::cout << "Usage: BenchmarkPublisher Data_Size_In_KB" << std::endl;
		return -1;
	}

	N = atoi(argv[1]);

	// Set up YARP


	Publisher publisher;
	Subscriber subscriber;

	subscriber.start();


	publisher.run();



	return 0;
}

