/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file UUIDTest.C
 *    Test cases for UUID.h.
 *
 * @author Tim Langner
 * @date   2010/10/18
 */

#include <sstream>
#include <boost/test/unit_test.hpp>

#include <utils/UUID.h>
#include <serialization/XMLSerializer.h>
#include <serialization/BinarySerializer.h>
#include <serialization/JSONSerializer.h>

using namespace mira;

BOOST_AUTO_TEST_CASE( UUIDBaseTest )
{
	boost::uuids::random_generator gen;
	UUID uuid = gen();

	XMLDom xml;
	XMLSerializer s(xml);

	s.serialize("Uuid", uuid, "");
//	xml.saveToFile("out.xml");

	XMLDeserializer ds(xml);
	UUID uuid2;
	ds.deserialize("Uuid", uuid2);

	BOOST_CHECK_EQUAL(uuid, uuid2);

	Buffer<uint8> buffer;
	BinaryBufferSerializer bs(&buffer);
	bs.serialize(uuid,false);

	UUID uuid3;
	BinaryBufferDeserializer bd(&buffer);
	bd.deserialize(uuid3,false);

	BOOST_CHECK_EQUAL(buffer.size(),
	                  UUID::static_size() + BinaryBufferSerializer::formatVersionOverhead());

	BOOST_CHECK_EQUAL(uuid, uuid3);

	JSONSerializer js;
 	json::Value v = js.serialize(uuid);

	JSONDeserializer jd(v);
	UUID uuid4;
 	jd.deserialize(uuid4);
	BOOST_CHECK_EQUAL(uuid, uuid4);
}
