/*
 * Copyright (C) 2025 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */
/**
 * @file Uitls.h
 *    Utils for XMLMacros.
 *
 * @author Adrian Kriegel
 * @date   Fri Jan 17 2025
 */

#ifndef _MIRA_XML_MACROS_UTILS_H_
#define _MIRA_XML_MACROS_UTILS_H_

#include <serialization/XMLSerializer.h>
#include <xml/XMLDomReflect.h>

#include <xml/macros/Types.h>

namespace mira::xmlmacros {

class CopyableXMLDom : public XMLDom
{
public:
	CopyableXMLDom() = default;
	CopyableXMLDom(CopyableXMLDom&& dom) : XMLDom(std::move(dom)) {}
	CopyableXMLDom(const CopyableXMLDom& dom);

	CopyableXMLDom& operator=(const CopyableXMLDom& dom);

	void reflect(XMLDeserializer& r)
	{
		MIRA_REFLECT_BASE(r, XMLDom);
		setUri(r.getNode().uri());
	}
}; // class CopyableXMLDom

/**
 * "Spreads" a node at the given location.
 * Copies all attributes into the parent node.
 * Copies all children into the parent node at the location.
 * Optionally removes the location marker (if @param deleteLocation is true).
 * @param location Marker for the location. Will be removed.
 * @param node Node to spread.
 * @param deleteLocation If true, the location marker will be removed.
 * @returns parent node
 */
XMLNode spreadNode(XMLNode location, XMLDom::const_iterator node, bool deleteLocation = true);

} // namespace mira::xmlmacros

#endif // _MIRA_XML_MACROS_UTILS_H_
