/*
 * Copyright (C) 2025 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file Types.h
 *    Types for XMLMacros.
 *
 * @author Adrian Kriegel
 * @date   Fri Jan 17 2025
 */

#ifndef _MIRA_XML_MACROS_TYPES_H_
#define _MIRA_XML_MACROS_TYPES_H_

#include <string>

#include <error/Exceptions.h>
#include <serialization/XMLSerializer.h>
#include <xml/XMLDom.h>

#include <serialization/adapters/std/shared_ptr.hpp>
#include <serialization/adapters/std/vector>

namespace mira {

using XMLNode = XMLDom::sibling_iterator;

}

namespace mira::xmlmacros {

struct SourceInfo
{
	std::string file;
	uint32 line;
};

class XMacro : public XInvalidConfig
{
public:
	using XInvalidConfig::XInvalidConfig;

	void setMacroStack(std::vector<SourceInfo> stack)
	{
		mStack = std::move(stack);
	}

	const std::vector<SourceInfo>& getMacroStack()
	{
		return mStack;
	}

protected:

	std::vector<SourceInfo> mStack;
}; // class XMacro

class XMissingParameter : public XMacro
{
public:
	using XMacro::XMacro;
}; // class XMissingParameter

class XMaxDepth : public XMacro
{
public:
	using XMacro::XMacro;
}; // class XMissingParameter

} // namespace mira::xmlmacros

#endif // _MIRA_XML_MACROS_TYPES_H_