/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file Velocity.h
 *    Velocity typedefs for representing translational and angular velocities in
 *    2D and 3D as RigidTransforms.
 *
 * @author Tim Langner
 * @date   2011/01/09
 */

#ifndef _MIRA_VELOCITY_H_
#define _MIRA_VELOCITY_H_


#include <transform/RigidTransform.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/// A 2D velocity consisting of a translational and rotational part.
typedef RigidTransform<float,2> Velocity2;

/// A 3D velocity consisting of a translational and rotational part.
typedef RigidTransform<float,3> Velocity3;

/// A 2D velocity with covariance consisting of a translational and rotational part.
typedef RigidTransformCov<float,2> VelocityCov2;

/// A 3D velocity with covariance consisting of a translational and rotational part.
typedef RigidTransformCov<float,3> VelocityCov3;

/// Vector of Velocity2
typedef std::vector<Velocity2, Eigen::aligned_allocator<Velocity2>> Velocity2Vector;
/// Vector of Velocity3
typedef std::vector<Velocity3, Eigen::aligned_allocator<Velocity3>> Velocity3Vector;

/// Vector of VelocityCov2
typedef std::vector<Velocity2, Eigen::aligned_allocator<VelocityCov2>> VelocityCov2Vector;
/// Vector of VelocityCov3
typedef std::vector<Velocity3, Eigen::aligned_allocator<VelocityCov3>> VelocityCov3Vector;

///////////////////////////////////////////////////////////////////////////////

}

#endif
