/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file AbstractInterfaceCallbackHandler.h
 *    Abstract interface for handler(s) that get called upon new services with
 *    a special interface get available.
 *
 * @author Tim Langner
 * @date   2012/03/28
 */

#ifndef _MIRA_ABSTRACTINTERFACECALLBACKHANDLER_H_
#define _MIRA_ABSTRACTINTERFACECALLBACKHANDLER_H_

namespace mira {

//////////////////////////////////////////////////////////////////////////////

/**
 * @ingroup RPCModule
 * Abstract interface for derived handler(s).
 * The actual derived handler should manage an internal list of new services.
 * Additionally, the handler usually will have its own thread
 * for processing and relaying those pending new services.
 */
class AbstractInterfaceCallbackHandler
{
public:
	virtual ~AbstractInterfaceCallbackHandler() {}

public:

	/**
	 * Notifies that a new service that implements a special interface is available
	 */
	virtual void newServiceInterface(const std::string& interface,
	                                 const std::string& service) = 0;
};

typedef boost::shared_ptr<AbstractInterfaceCallbackHandler> AbstractInterfaceCallbackHandlerPtr;

//////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
