/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file Environment.h
 *    Functions for platform independent resolving of environment variables.
 *
 * @author Tim Langner
 * @date   2011/02/21
 */

#ifndef _MIRA_ENVIRONMENT_H_
#define _MIRA_ENVIRONMENT_H_

#include <string>

#include <platform/Types.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * Resolves an environmental variable. The variable must not contain $, ${}
 * or %%. e.g. for resolving $MY_VAR just pass "MY_VAR" as envVar.
 * @throws XInvalidConfig if envVar is not a valid environmental variable
 * @param[in] envVar The environment variable to be resolved (the plain name)
 * @return The resolved string
 */
std::string resolveEnvironmentVariable(const std::string& envVar);

/**
 * Resolves all environmental variables in a string: It replaces
 * $VARIABLE
 * ${VARIABLE}
 * %VARIABLE%
 * by the content of the environment variable VARIABLE.
 * @param[in] envStr The string to be resolved
 * @param[in] ignoreErrors If true resolving will be continued even if one variable 
 * can not be resolved.
 * @return The resolved string
 */
std::string resolveEnvironmentVariables(std::string envStr,
                                                         bool ignoreErrors = true);

///////////////////////////////////////////////////////////////////////////////

}

#endif
