/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file LogConsoleSink.h
 *    Logging sink for log output to console.
 *
 * @author Tim Langner
 * @date   2011/02/02
 */

#ifndef _MIRA_LOGCONSOLESINK_H_
#define _MIRA_LOGCONSOLESINK_H_

#include <error/LogTxtStreamSink.h>
#include <platform/Console.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * Special class that uses LogTxtStreamSink as a base and cout as stream
 * Provided for logging to console. Does some coloring based on the log
 * level of the message (coloring is available only, if it supported by the
 * console/shell).
 * The coloring can be enabled or disabled using the enableColors()
 * method. By default coloring is enabled.
 * @ingroup LoggingModule
 */
class LogConsoleSink : public LogTxtStreamSink
{
public:
	/// Default constructor
	LogConsoleSink();

	virtual void consume(const LogRecord& record);

public:

	/**
	 * Enables or disables the colored text output based on the specified
	 * flag.
	 */
	void enableColors(bool enable=true);

private:
	void setTextColor(console::TextColor color);

private:
	bool mColoringEnabled;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif
