/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

#include <serialization/adapters/std/vector>
#include <serialization/adapters/boost/shared_ptr.hpp>

/**
 * Some class definitions with many different members
 * and reflect methods
 */

class Pose
{
public:

	Pose() {}
	Pose(float iX, float iY, float iPhi) :
		x(iX), y(iY), phi(iPhi) {}

public:

	float x,y,phi;

};


// nonintrusive reflect
template<typename Reflector>
void reflect(Reflector& r, Pose& p)
{
	r.member("x",p.x, "");
	r.member("y",p.y, "");
	r.member("phi",p.phi, "");
}



class MyClass
{

public:

	MyClass() : i(123), j(876)
	{
		intPtr = &i;
	}

    template<typename Reflector>
    void reflect(Reflector& r)
    {
        r.member("i", i, "");
        r.member("j", j, "");
        //r.member("ptr", intPtr, "");
    }

private:

    int  i,j;
    int* intPtr;

};


class MyClass2
{

public:

	MyClass2() {
		sharedPtr.reset(new MyClass);
		mEnum = VALUE2;
		mEnumPtr = &mEnum;
		mArray[0]=1;
		mArray[1]=2;
		mArray[2]=3;
	}

    template<typename Reflector>
    void reflect(Reflector& r)
    {
        r.member("object", mObject, "");
        r.member("poses",  mPoses, "all of our poses");
        r.member("posePtr",mPosePtr, "");
        //r.member("ptr",mPtr, "");
        r.member("sharedPtr", sharedPtr, "");
        r.member("enum", mEnum	, "");
        r.member("enumPtr", mEnumPtr	, "");
        r.member("array", mArray, "");
    }

    enum MyEnum {
    	VALUE1=1,
    	VALUE2,
    	VALUE3
    };

    MyClass mObject;
    std::vector<Pose> mPoses;
    Pose* mPosePtr;
    float* mPtr;

    boost::shared_ptr<MyClass> sharedPtr;
    MyEnum mEnum;
    MyEnum* mEnumPtr;

    int mArray[3];
};
