/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PointsExample.C
 *    An example how to use points.
 *
 * @author Jens Kessler
 * @date   2010/08/11
 */

#include <iostream>
#include <geometry/Geometry.h>

#include <boost/geometry/algorithms/distance.hpp>
#include <boost/geometry/strategies/strategies.hpp>

using namespace std;
using namespace mira;

int main()
{
	// create a bunch of points
	Point2i A;
	Point3f B;
	Point<double,4> C;
	Point3f D(1.0, 0.0, -1.0);
	Point3i E(2, 3, 4);

	// access on points

	// 2D
	A.x() = 0;
	A.y() = 1;

	// 3D
	B.x() = 0.0;
	B.y() = 1.0;
	B.z() = 2.0;

	// 4D
	C[0] = 0.0;
	C[1] = 1.0;
	C[2] = 2.0;
	C[3] = 3.0;

	// output them
	cout << "Point A (2D):" << endl << A << endl;
	cout << "Point B (3D):" << endl << B << endl;
	cout << "Point C (4D):" << endl << C << endl;
	cout << "Point D (3D):" << endl << D << endl;
	cout << "Point E (3D):" << endl << E << endl;

	// simple operations

	cout << "Simple operations:" << endl;
	cout << "------------------" << endl;
	cout << endl << "B + D = " << B + D << endl;
	cout << endl << "B - D = " << B - D << endl;
	cout << "Different point types but same dimension:" << endl;
	cout << "----------------------------------------" << endl;
	cout << endl << "D + E = " << D + E.cast<float>() << endl;
	cout << "More operations:" << endl;
	cout << "----------------------------------------" << endl;
	cout << endl << "DotProduct(B * D) = " << B.dot(D) << endl;
	cout << endl << "DotProduct(B*D)V2 = " << B.transpose() * D << endl;
	cout << endl << "CrossProduct(BxD) = " << B.cross(D) << endl;
	cout << endl << "Element Wise product (B * D) = " << B.array() * D.array() << endl;
	cout << endl << "Dyadic product (B * D') = " << B * D.transpose() << endl;

	float d = boost::geometry::distance(B,D);
	cout << "Euklidian distance (B->D) = " << d << endl;

	return 0;
}
