/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file TapeView.C
 *    Implementation of TapeView.h.
 *
 * @author Tim Langner
 * @date   2012/01/01
 */

#include <TapeView.h>

#include <QHeaderView>
#include <QVBoxLayout>

#include <TapeEditor.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

TapeView::TapeView(TapeEditor* parent) :
	QSplitter(parent)
{
	mEditor = parent;
	mChannelView = new TapeChannelView(this, parent);
	QWidget* vBox = new QWidget(this);
	mTimeView = new TapeTimeView(vBox, parent);
	mDataView = new TapeDataView(vBox, parent);

	QVBoxLayout* vBoxLayout = new QVBoxLayout(vBox);
	vBoxLayout->setMargin(0);
	vBoxLayout->setSpacing(0);
	vBoxLayout->addWidget(mTimeView);
	vBoxLayout->addWidget(mDataView);
	vBox->setLayout(vBoxLayout);

	setHandleWidth(2);
	setStretchFactor(0, 0);
	setStretchFactor(1, 1);

	// set a default location for the splitter
	QList<int> list;
	list << 350 << 400;
	setSizes(list);

	mTimeView->setFixedHeight((mChannelView->getHeader())->sizeHint().height());
	
	QObject::connect(mChannelView, SIGNAL(contentsMoving(int,int)),
	                 mDataView, SLOT(onContentsMoving(int,int)));
	QObject::connect(mDataView, SIGNAL(contentsMoving(int,int)),
	                 mTimeView, SLOT(onContentsMoving(int,int)));
	QObject::connect(mDataView, SIGNAL(contentsMoving(int,int)),
	                 mChannelView, SLOT(onContentsMoving(int,int)));
}

void TapeView::centerContents()
{
	updateContents();
	mDataView->setContentsPos(mEditor->getSelectionStartX(), mDataView->contentsY());
	mDataView->updateContents();
}

void TapeView::updateContents()
{
	mChannelView->updateContentsHeight();
	mDataView->updateContentsWidth();
}

///////////////////////////////////////////////////////////////////////////////

}
