/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file GitlabAPITest.C
 *    Test cases for GitlabAPI
 * @date 2019/11/25
 *
 * @author Thomas Bauer
 */
#ifndef _GITLABAPI_TEST_
#define _GITLABAPI_TEST_

#include <iostream>
#include <boost/test/unit_test.hpp>
#include <boost/algorithm/string.hpp>
#include <app/GitlabAPI.h>
#include <utils/Foreach.h>


using namespace mira;
using namespace std;
using namespace gitlab;

// set credentials here
static std::string gitlab_user = "test";
static std::string gitlab_pass = "password";
static std::string gitlab_token = "token";

BOOST_AUTO_TEST_CASE( testInstance ) {
	GitlabAPI gl("https://gitlab.example.com");
}

BOOST_AUTO_TEST_CASE( testInstanceUrl ) {
	GitlabAPI gl("https://gitlab.example.com/test");
	BOOST_CHECK_EQUAL(gl.instanceUrl(), "https://gitlab.example.com");
	try{
		GitlabAPI glx("http:");
		BOOST_CHECK(false);
	} catch (...) {}
	GitlabAPI gl2("gitlab.example.com");
	BOOST_CHECK_EQUAL(gl2.instanceUrl(), "https://gitlab.example.com");

	GitlabAPI gl3("http://gitlab.example.com");
	BOOST_CHECK_EQUAL(gl3.instanceUrl(), "https://gitlab.example.com");
}

BOOST_AUTO_TEST_CASE( testLogin ) {
	if( gitlab_pass != "password" ) {
		GitlabAPI gl("https://gitlab.metralabs.com");
		//gl.setVerbose();
		gl.checkSSLCerts(false);
		
		BOOST_CHECK_EQUAL(gl.loggedIn(), false);
		BOOST_CHECK_EQUAL(gl.login(gitlab_user, "test1234"), false);
		BOOST_CHECK_EQUAL(gl.loggedIn(), false);
		BOOST_CHECK_EQUAL(gl.login(gitlab_user, gitlab_pass), true);
		BOOST_CHECK_EQUAL(gl.loggedIn(), true);
	}
}

BOOST_AUTO_TEST_CASE( testProjects ) {
	if( gitlab_pass != "password" ) {
		GitlabAPI gl("https://gitlab.metralabs.com");
		gl.checkSSLCerts(false);
		
		BOOST_CHECK_EQUAL(gl.login(gitlab_user, gitlab_pass), true);
		//gl.setVerbose();
		auto pro = gl.projects();
		BOOST_CHECK_EQUAL(pro.size() > 0, true);
		// foreach(auto p, pro) {
		//     std::cout << "Project Name: " << p.name  << std::endl;
		// }
	}
}

BOOST_AUTO_TEST_CASE( testNamespaces ) {
	if( gitlab_pass != "password" ) {
		GitlabAPI gl("https://gitlab.metralabs.com");
		gl.checkSSLCerts(false);
		
		BOOST_CHECK_EQUAL(gl.login(gitlab_user, gitlab_pass), true);
		//gl.setVerbose();
		auto ns = gl.namespaces();
		BOOST_CHECK_EQUAL(ns.size() > 0, true);
		//foreach(auto n, ns) {
		//    std::cout << "Namespaces: " << n.name  << std::endl;
		//}
	}
}

BOOST_AUTO_TEST_CASE( testApplicationToken ) {
	if( gitlab_token != "token" ) {
		GitlabAPI gl("https://gitlab.metralabs.com");
		gl.checkSSLCerts(false);
		BOOST_CHECK_EQUAL(gl.provideApplicationToken(gitlab_token), true);
		BOOST_CHECK_EQUAL(gl.projects().size() > 0, true);
	}
}
#endif
