/*
 * Copyright (C) by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PanoramaCameraIntrinsic.C
 *    implementation of intrinsic parameters for Panorama cameras
 *    Cylindrical Equidistant Projection
 *
 * @author Michael Volkhardt
 * @date   2011/09/22
 */

#include <cameraparameters/PanoramaCameraIntrinsic.h>

using namespace Eigen;

namespace mira {
namespace camera {

///////////////////////////////////////////////////////////////////////////////

PanoramaCameraIntrinsicNormalized::PanoramaCameraIntrinsicNormalized() {
	minPhi = 0;
	maxPhi = 2 * M_PI;
	minHeight = 0.;
	maxHeight = 1.;
}

PanoramaCameraIntrinsicNormalized::PanoramaCameraIntrinsicNormalized(
		float iMinPhi, float iMaxPhi, 
		float iMinHeight, float iMaxHeight, 
		const RigidTransform3f& iDirection) {

	minPhi = iMinPhi;
	maxPhi = iMaxPhi;
	minHeight = iMinHeight;
	maxHeight = iMaxHeight;
	direction = iDirection;

}

///////////////////////////////////////////////////////////////////////////////

PanoramaCameraIntrinsic::PanoramaCameraIntrinsic() {
	minPhi = 0;
	maxPhi = 2 * M_PI;
	minHeight = 0.;
	maxHeight = 1.;
}

PanoramaCameraIntrinsic::PanoramaCameraIntrinsic(
		float iMinPhi, float iMaxPhi,
		float iMinHeight, float iMaxHeight, 
		float iWidth, float iHeight, 
		const RigidTransform3f& iDirection) {
	minPhi = iMinPhi;
	maxPhi = iMaxPhi;
	minHeight = iMinHeight;
	maxHeight = iMaxHeight;
	width = iWidth;
	height = iHeight;
	direction=iDirection;
}

PanoramaCameraIntrinsic::PanoramaCameraIntrinsic(
		const PanoramaCameraIntrinsicNormalized& iNormIntrinParm,
		const Size2i& iImageSize) {

	minPhi = iNormIntrinParm.minPhi;
	maxPhi = iNormIntrinParm.maxPhi;
	minHeight = iNormIntrinParm.minHeight;
	maxHeight = iNormIntrinParm.maxHeight;
	width = iImageSize.width();
	height = iImageSize.height();
	direction=iNormIntrinParm.direction;

}

///////////////////////////////////////////////////////////////////////////////
}
} // namespace
