#!/bin/bash

###############################################################################
#
# A bash script, which determines the revision of the specified directory
#
# Author: Christian Martin
#
###############################################################################

# Extract and check the command line arguments

if [ $# != 1 ]; then
	echo "Usage: $0 Path"
	exit
fi

###############################################################################

cd $1

# first, try svn
#SVN_REV=`svn info --show-item last-changed-revision`
SVN_REV=`LC_ALL=C svn info 2> /dev/null | grep 'Last Changed Rev' | awk '{ print $4; }'`
if [ ! -z "${SVN_REV}" ]; then
	echo "SVN-r${SVN_REV}"
	exit
fi

# second, try git
GIT_REV=`git rev-parse HEAD`
if [ $? -eq 0 ]; then
	echo "GIT-r${GIT_REV}"
	exit
fi

echo "unknown-revision"
