var offlinePackages;

function isOffline()
{
	return (document.URL.substr(0,5)=="file:");
}

function loadJSON(callback) {   

    var xobj = new XMLHttpRequest();
        xobj.overrideMimeType("application/json");
    xobj.open('GET', 'availableDocs.json', false);
    xobj.onreadystatechange = function () {
          if (xobj.readyState == 4 && xobj.status == "200") {
            // Required use of an anonymous callback as .open will NOT return a value but simply returns undefined in asynchronous mode
            callback(xobj.responseText);
          }
    };
    xobj.send(null);  
}
	
function generateDocAppletScript()
{
	if(isOffline()) {
		loadJSON(function(response) {
		  // Parse JSON string into object
		    offlinePackages = JSON.parse(response);
		 });
	}
	// else no applet needed for online help	
}

function generateDocRefTable(path, onlineDirs)
{
	var app = document.getElementById("MIRADocApplet");
	var dirs = null;

	if(isOffline()) {
		dirs = offlinePackages[path];
	} else {
		// use provided online dirs, if in online mode
		dirs = onlineDirs;
	}
	
	if(dirs!=null) {
		document.write("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">");
		document.write("<tr valign=\"top\"><th>");
		var rows = dirs.length / 3;
		if(rows<3) rows=3; // avoid too short columns, if there are just a few entries
		var i = 0;
		var curprefix = ""; // current subdir prefix
		for(var col=0; col<3; ++col)
		{
			document.write("<ul class=\"menu\">");
			for(var j=0;j<rows && i<dirs.length; i+=2,++j)
			{
				var relpath = dirs[i];
				var fullpath = dirs[i+1];

				// extract the parts of the relpath
				var parts = relpath.split("/");
				
				// the last part becomes our displayed text
				var text = parts[parts.length-1];
				
				// build a prefix dir from the first parts of the relpath path
				var prefix = "";
				for(var k=0; k<parts.length-1; ++k)
				{	
					if(k!=0) prefix += "/";
					prefix += parts[k]; 
				}
				
				// if the prefix has changed (or we have started a new column), then
				// show the prefix
				if(prefix!=curprefix || (j==0 && prefix.length>0)) {
					document.write("</ul>" + prefix + ":<ul class=\"menu\">");
					curprefix = prefix;
				}
				document.write("<li><a href=\"" + fullpath + "/index.html\">" + text + "</a></li>");
			}	
			document.write("</ul>");
			// begin next column
			if(col<2)
				document.write("</th><th>");
		}
		document.write("</th></tr></table>");
	}
	
}
