###############################################################################
# OpenCV
###############################################################################

FIND_PACKAGE(OpenCV REQUIRED)

IF(${OpenCV_VERSION} VERSION_LESS "2.2.0")
	MESSAGE(FATAL_ERROR "Need at least OpenCV Version 2.2.0")
ENDIF()

SET(OPENCV_INCLUDE_DIRS ${OpenCV_INCLUDE_DIRS})
SET(OPENCV_LIBRARY_DIRS ${OpenCV_LIB_DIR})

# fix for opencv >=2.3 where OPENCV_LIB_COMPONENTS is renamed into OpenCV_LIB_COMPONENTS
if(${OpenCV_VERSION} VERSION_GREATER "2.2.0")
	SET(OPENCV_LIB_COMPONENTS ${OpenCV_LIB_COMPONENTS})
endif()

# Create a linker variable for each OpenCV component
IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "Found following OpenCV components:")
ENDIF()

FOREACH(cvLib ${OPENCV_LIB_COMPONENTS})
	IF(OpenCV_USE_MANGLED_PATHS)
		# In this case, ${cvLib} is a full file name to the shared library.
		# Therefore, we have to extract the actual name of the component.
		GET_FILENAME_COMPONENT(baseName ${cvLib} NAME_WE)

		# Remove the "lib" prefix
		STRING(SUBSTRING ${baseName} 0 3 libPrefix)
		IF(${libPrefix} STREQUAL "lib")
			STRING(SUBSTRING ${baseName} 3 -1 baseName)
		ENDIF()
		STRING(TOUPPER "${baseName}" baseNameUpper)
		SET(${baseNameUpper}_LIBRARY "${cvLib}")
		IF (CMAKE_VERBOSE_MAKEFILE)
			MESSAGE(STATUS "   ${baseNameUpper}_LIBRARY -> ${cvLib}")
		ENDIF()
	ELSE()
		# In this case, ${cvLib} is just the name of the component. So we
		# simply can use it.
		STRING(TOUPPER "${cvLib}" cvLibUpper)
		SET(${cvLibUpper}_LIBRARY "${cvLib}")
		IF (CMAKE_VERBOSE_MAKEFILE)
			MESSAGE(STATUS "   ${cvLibUpper}_LIBRARY -> ${cvLib}")
		ENDIF()
	ENDIF()
ENDFOREACH(cvLib)

###############################################################################

IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "OPENCV")
	MESSAGE(STATUS "   incdir   = " ${OPENCV_INCLUDE_DIRS})
	MESSAGE(STATUS "   libdir   = " ${OPENCV_LIBRARY_DIRS})
ENDIF (CMAKE_VERBOSE_MAKEFILE)

