###############################################################################
# Copyright (C) 2013 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################

if (WITHOUT_GUI)
	return()
endif()

if (QT_CMAKE_INCLUDED)
	return()
endif()
set(QT_CMAKE_INCLUDED 1)

###############################################################################

if(FORCE_USE_QT4)
	IF(NOT DEFINED MIRA_QT_VERSION)
		message(STATUS "(Forced) Using Qt4")
		SET(MIRA_QT_VERSION 4 CACHE INTERNAL "current used Qt version" FORCE)
	ENDIF()

	include(Qt4)
else()
	# try to find Qt5 first
	find_package(Qt5Widgets QUIET)
	
	if(Qt5Widgets_FOUND)
		IF(NOT DEFINED MIRA_QT_VERSION)
			message(STATUS "Using Qt5")
			SET(MIRA_QT_VERSION 5 CACHE INTERNAL "current used Qt version" FORCE)
		ELSEIF(NOT MIRA_QT_VERSION EQUAL 5)
			message(WARNING "Chosen QT version switched from ${MIRA_QT_VERSION} to 5")
			SET(MIRA_QT_VERSION 5 CACHE INTERNAL "current used Qt version" FORCE)
		ENDIF()
		
		include(Qt5)
	else()
		IF(NOT DEFINED MIRA_QT_VERSION)
			message(STATUS "Using Qt4")
			SET(MIRA_QT_VERSION 4 CACHE INTERNAL "current used Qt version" FORCE)
		ELSEIF(NOT MIRA_QT_VERSION EQUAL 4)
			message(WARNING "Chosen QT version switched from ${MIRA_QT_VERSION} to 4")
			SET(MIRA_QT_VERSION 4 CACHE INTERNAL "current used Qt version" FORCE)
		ENDIF()

		include(Qt4)
	endif()
endif()

###############################################################################

include(CMakeParseArguments)

###############################################################################
# A macro for adding the lrelease command to the build chain. This macro
# is used by MIRA_QT_CREATE_TRANSLATION (see below).

macro(MIRA_QT_ADD_TRANSLATION _qm_files)

	foreach(_current_FILE ${ARGN})
		get_filename_component(tsFileName ${_current_FILE} NAME)
		get_filename_component(_abs_FILE ${_current_FILE} ABSOLUTE)
		get_filename_component(qm ${_abs_FILE} NAME_WE)
		get_source_file_property(output_location ${_abs_FILE} OUTPUT_LOCATION)
		if(output_location)
			file(MAKE_DIRECTORY "${output_location}")
			set(qm "${output_location}/${qm}.qm")
		else()
			set(qm "${CMAKE_CURRENT_BINARY_DIR}/${qm}.qm")
		endif()

		# Add a custom command for the lrelease step. This target depends on
		# the ts-Files AND also on the dummy OUTPUT target of the lupdate step
		# (see below).
		ADD_CUSTOM_COMMAND(OUTPUT ${qm}
			COMMAND ${QT_LRELEASE_EXECUTABLE}
			ARGS ${_abs_FILE} -qm ${qm}
			DEPENDS ${_abs_FILE}
			DEPENDS ${CMAKE_CURRENT_BINARY_DIR}/${tsFileName}.output
			VERBATIM
		)
		set(${_qm_files} ${${_qm_files}} ${qm})
	endforeach(_current_FILE)

endmacro(MIRA_QT_ADD_TRANSLATION)

###############################################################################
# A macro for adding Qt translations to a target
#
# This macro will create an own Qt resource file for the generated qm-files.
# The qrc file is generated inside the binary directory besides the qm-files.
# An optional qrc prefix can be specified by using QRCPREFIX to avoid conflicts
# with other resources.
# The name of the generated file is returned in _qm_qrc_file. This file should
# be added by using QT_ADD_RESOURCES.
#
# Usage:
#   MIRA_QT_CREATE_TRANSLATION(
#      _qm_files                             resulting list of qm-files
#      _qm_qrc_file                          resulting generated qrc file, which
#                                            contains only the translations
#      target                                name of the target
#      [TRANSLATIONS <trFile1 ... trFileN>]  list of tr-files
#      [FILES        <file1 ... fileN>]      files to translate
#      [DIRS         <dir1 ... dirN>]        dirs to translate
#      [INCLUDE      <dir1 ... dirN>]        include directories
#      [OPTIONS      <opt1 ... optN>]        additional options for lupdate
#      [QRCPREFIX    <prefix>]               optional prefix for the qrc file
#   )
#
macro(MIRA_QT_CREATE_TRANSLATION _qm_files _qm_qrc_files target)

	# Split argument list
	CMAKE_PARSE_ARGUMENTS(arg
		# options:
		""
		# one-value arguments:
		"QRCPREFIX"
		# multi-value arguments:
		"TRANSLATIONS;FILES;DIRS;INCLUDES;OPTIONS"
		${ARGN})
		
	ADD_CUSTOM_TARGET(${target}_translations)

	# Generate a lupdate command for each translation file
	foreach(tsFile ${arg_TRANSLATIONS})

		# Prepare list of include directories
		unset(fullIncludes)
		foreach(inclDir ${arg_INCLUDES})
			list(APPEND fullIncludes -I ${inclDir})
		endforeach()

		# absolute path to current ts-file
		get_filename_component(absTsFile "${tsFile}" ABSOLUTE)
		get_filename_component(tsFileName ${tsFile} NAME)

		# Create the lupdate command. This command MUST not have the absTsFile
		# as OUTPUT. Otherwise the ts file would be deleted(!) during a
		# "make clean". Therefore, this target has a dummy OUTPUT (*.output)
		# and the lrelease step (see above) depends on the ts file and the
		# dummy output.
		ADD_CUSTOM_COMMAND(
			OUTPUT ${CMAKE_CURRENT_BINARY_DIR}/${tsFileName}.output
			COMMAND ${QT_LUPDATE_EXECUTABLE}
				ARGS ${arg_OPTIONS} ${arg_FILES} ${arg_DIRS} ${fullIncludes} -ts ${absTsFile}
			COMMAND ${CMAKE_COMMAND}
				ARGS -E touch ${CMAKE_CURRENT_BINARY_DIR}/${tsFileName}.output
			DEPENDS ${arg_FILES}
			WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}
			VERBATIM
			COMMENT "Updating ${tsFile}")

	endforeach()

	# Add the lrelease command to the build chain
	MIRA_QT_ADD_TRANSLATION(${_qm_files} ${arg_TRANSLATIONS})

	# Generate a separate Qt resource file, which only contains the qm files.
	set(qmQrcFile ${CMAKE_CURRENT_BINARY_DIR}/${target}_translations.qrc)
	file(WRITE ${qmQrcFile} "<RCC><qresource prefix=\"${arg_QRCPREFIX}\">")
	foreach(qmFile ${${_qm_files}})
		get_filename_component(qmFileBase ${qmFile} NAME)
		file(APPEND ${qmQrcFile} "<file>${qmFileBase}</file>")
	endforeach()
	file(APPEND ${qmQrcFile} "</qresource></RCC>")

	set(${_qm_qrc_files} ${qmQrcFile})

endmacro(MIRA_QT_CREATE_TRANSLATION)
