###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Dependencies to other projects (that may be installed on the local
# system or that need to be downloaded from external resources)
# Downloaded external projects are stored in {ROOT}/external/...
#
###############################################################################

INCLUDE( ${CMAKE_ROOT}/Modules/FindPkgConfig.cmake )
INCLUDE(FindPkgConfig)

INCLUDE(dependencies/Boost)
INCLUDE(dependencies/Eigen)
#INCLUDE(dependencies/FreeType)
INCLUDE(dependencies/JSON)
INCLUDE(dependencies/LibIConv)
INCLUDE(dependencies/LibXML)
INCLUDE(dependencies/NCurses)
INCLUDE(dependencies/OpenSSL)
INCLUDE(dependencies/OpenCV)
INCLUDE(dependencies/SQLite)
INCLUDE(dependencies/ZLib)
INCLUDE(dependencies/LibBZip2)
INCLUDE(dependencies/Procps)

INCLUDE(dependencies/BfdDemangle)
INCLUDE(dependencies/PThread)

###############################################################################

# Create a custom target 'MIRAExternalDependencies', which can be used as a
# dependency to ensure, that all external dependencies are available before
# building a target.
ADD_CUSTOM_TARGET(MIRAExternalDependencies)

# list of possible dependencies (depends on the system)
SET(dependenciesTargetList
	Eigen
	Geometry
	JSON
	LibIconv
	NCurses
	OpenSSL
	OpenCV
	SQLite
	XML2
	ZLib
)

# only add existing target to avoid cmake warnings
FOREACH(depTarget ${dependenciesTargetList})
	IF(TARGET ${depTarget})
		ADD_DEPENDENCIES(MIRAExternalDependencies ${depTarget})
	ENDIF()
ENDFOREACH(depTarget)
