###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Provides MIRA_ADD_TEST macro as alternative for the build-in
# ADD_TEST macro. This macro perform the following steps:
#   1.) Add the test as a new target using ADD_TEST
#   2.) Add test as dependency of package
#   3.) Set label properties of test
#   4.) Adds test executable
#   5.) Links against libraries
#
# Usage:
#    MIRA_ADD_TEST(ExecutableName
#                  [PACKAGE        <package>]
#                  [SOURCE         <source1 ... sourceN>]
#                  [QT_UIs         <ui1 ... uiN>]
#                  [QT_MOCs        <moc1 ... mocN>]
#                  [QT_QRCs        <qrc1 ... qrcN>]
#                  [LINK_LIBS      <lib1 ... libN>]
#                  )
#
# Author: Ronny Stricker, Tim Langner
#
###############################################################################

INCLUDE(CMakeParseArguments)

###############################################################################

MACRO(MIRA_ADD_TEST target)

	###########################################################################
	# Parse the macro arguments

	CMAKE_PARSE_ARGUMENTS(arg
		# options:
		""
		# one-value arguments:
		"PACKAGE"
		# multi-value arguments:
		"SOURCE;QT_UIs;QT_MOCs;QT_QRCs;LINK_LIBS"
		${ARGN})

	###########################################################################

	IF (arg_PACKAGE)
		# Add binary to package target
		# check if target already exists
		IF( NOT TARGET PACKAGE_${arg_PACKAGE} )
			ADD_CUSTOM_TARGET( PACKAGE_${arg_PACKAGE} )
		ENDIF()
		ADD_DEPENDENCIES(PACKAGE_${arg_PACKAGE} ${target})
	ENDIF()

	###########################################################################
	# Ensure, that we have at least one source file
	IF (NOT arg_SOURCE)
		MESSAGE(FATAL_ERROR "Target ${target} has no source files.")
	ENDIF()

	###########################################################################

	# Qt4 ui-Files
	SET(UI_HDRS "")
	IF (arg_QT_UIs)
		QT_WRAP_UI(UI_HDRS ${arg_QT_UIs})
		INCLUDE_DIRECTORIES(${CMAKE_CURRENT_BINARY_DIR})
	ENDIF()

	# Qt4 moc
	SET(MOC_SRC "")
	IF (arg_QT_MOCs)
		QT_WRAP_CPP(MOC_SRC ${arg_QT_MOCs})
	ENDIF()

	# Qt4 resources
	SET(RCC_SRCS "")
	IF (arg_QT_QRCs)
		QT_ADD_RESOURCES(RCC_SRCS ${arg_QT_QRCs})
	ENDIF()

	###########################################################################
	# Add test executable

	ADD_EXECUTABLE(${target}
		${arg_SOURCE}
		${UI_HDRS}
		${MOC_SRC}
		${RCC_SRCS}
	)

	# set the macros BOOST_TEST_DYN_LINK and BOOST_TEST_MODULE that are needed
	# by the boost unit test framework
	SET_TARGET_PROPERTIES(${target} PROPERTIES COMPILE_FLAGS "-DBOOST_TEST_DYN_LINK -DBOOST_TEST_MODULE=${target} -DMIRA_PATHS=$ENV{MIRA_PATH}")

	# add -rdynamic / --export-dynamic to the linker
	#   (This option is needed for some uses of "dlopen" or to allow obtaining
	#    backtraces from within a program.)
	SET_TARGET_PROPERTIES(${target} PROPERTIES ENABLE_EXPORTS 1)

	###########################################################################
	# add the test
	ADD_TEST(${target} ${target}${CMAKE_EXECUTABLE_SUFFIX})

	###########################################################################
	# add transitive link libraries
	IF (MIRAAutoLinkLibraries)
		LIST(APPEND arg_LINK_LIBS ${MIRAAutoLinkLibraries})
	ENDIF()

	# link the binary
	TARGET_LINK_LIBRARIES(${target} 
		${BOOST_UNIT_TEST_FRAMEWORK_LIBRARY}
		${arg_LINK_LIBS}
	)

	# set label property (for CDash)
	SET_PROPERTY(TEST ${target} PROPERTY LABELS ${arg_PACKAGE})

ENDMACRO(MIRA_ADD_TEST)
