/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file Visualization.C
 *    Implementation of Visualization.
 *
 * @author Erik Einhorn
 * @date   2010/12/30
 */

#include <serialization/Serialization.h>
#include <visualization/Visualization.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

Visualization::Visualization() :
	Authority(Authority::ANONYMOUS | Authority::INTERNAL), mEnabled(true)
{
	ok();
}

Authority& Visualization::getAuthority()
{
	if (!isValid() )
	{
		checkin("/","Visualization");
		start();
	}
	return *this;
}

void Visualization::processUpdate(Duration dt)
{
	foreach(ChannelPropertyBase* prop, mChannelProperties)
	{
		try	{
			prop->update();
			if (prop->getDataUpdateCount() == 0)
				setStatus(Status::WARNING, prop->getName(),
				          "Channel has no data");
			else
				ok(prop->getName());
		} catch(Exception& ex) {
			// write error only, if the channel is not optional
			if(!prop->isOptional())
				setStatus(Status::ERROR, prop->getName(), ex.message(),
				          "Channel: ");
		} catch(std::exception& ex) {
			if(!prop->isOptional())
				setStatus(Status::ERROR, prop->getName(), ex.what(),
				          "Channel: ");
		} catch(...) {
			if(!prop->isOptional())
				setStatus(Status::ERROR, prop->getName(), "Unknown error",
				          "Channel: ");
		}
	}

	try
	{
		update(dt);
		ok("Transform");
		ok("Data");
		ok("Update");
	}
	catch(XInvalidRead& ex)
	{
		setStatus(Status::ERROR, "Data", ex.message(), "Error reading data");
	}
	catch(TransformerBase::XTransform& ex)
	{
		setStatus(Status::WARNING, "Transform", ex.message(), "Transformation error");
	}
	catch(Exception& ex)
	{
		setStatus(Status::ERROR, "Update", ex.message(), "Update error");
	}
}

///////////////////////////////////////////////////////////////////////////////

}

MIRA_CLASS_SERIALIZATION(mira::Visualization, mira::Object)
