/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file LineStripObject.h
 *    Renders a line list as billboard chain. In contrast to line
 *    lists of manual objects, this class supports lines with a width
 *    above 1 pixel.
 *
 * @author Erik Einhorn
 * @date   2012/11/06
 */

#ifndef _MIRA_LINELISTOBJECT_H_
#define _MIRA_LINELISTOBJECT_H_

#ifndef Q_MOC_RUN
#include <OGRE/OgreMaterial.h>
#endif

#include <visualization/3d/VisualizationObject.h>

///////////////////////////////////////////////////////////////////////////////

namespace Ogre {
	class BillboardChain;
}

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * Renders a line strip as billboard chain. In contrast to line
 * strips of manual objects, this class supports lines with a width
 * above 1 pixel.
 */
class LineListObject : public VisualizationObject
{
public:
	LineListObject(Ogre::SceneManager* sceneManager, Ogre::SceneNode* parent = NULL, int lineCountHint=1024);
	virtual ~LineListObject();

	virtual void setColor(const Ogre::ColourValue& color);

	/// Enables/disables alpha blending.
	void enableAlphaBlending(bool useAlpha=true);

	/// Sets the width of the line
	void setLineWidth(float width);

public:

	/**
	 * Clears all lines.
	 */
	void clear();

	/// Adds another line
	void add(const Ogre::Vector3& p1,const Ogre::Vector3& p2);

	/// Adds another point with the specified color to the line
	void add(const Ogre::Vector3& p1,const Ogre::Vector3& p2, const Ogre::ColourValue& color);

private:

	void nextChain();
	void newChain();

protected:
	int mLineCountHint;
	Ogre::MaterialPtr mMaterial;
	std::vector<Ogre::BillboardChain*> mChains;
	std::vector<int> mLinesInChain;
	int mCurChain;

	float mWidth;
	Ogre::ColourValue mColor;
};

///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
