/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file QtUnitTest.h
 *    Support for testing Qt GUI components from within boost unit tests.
 *    Just include this file and you can use the QTest::xyz methods in our
 *    BOOST test case to simulate mouse, keyboard events, etc.
 *    As an example see gui/tests/gui/GuiTestExample.C
 *
 * @author Erik Einhorn
 * @date   2012/03/22
 */

#ifndef _MIRA_QTUNITTEST_H_
#define _MIRA_QTUNITTEST_H_

#ifndef Q_MOC_RUN
#include <boost/test/unit_test.hpp>
#endif

# if QT_VERSION >= 0x050000
#include <QtWidgets/QtWidgets>
# else
#include <QtGui>
# endif

#include <QApplication>

///////////////////////////////////////////////////////////////////////////////

///@cond INTERNAL
struct QtInit
{
	QtInit() {
		static int argc = 1;
		static const char* argv[]={"Test Case"};
		app = new QApplication(argc,(char**)argv);
	}

	~QtInit() {
		delete app;
	}

	QApplication* app;
};
BOOST_GLOBAL_FIXTURE( QtInit );
///@endcond

///////////////////////////////////////////////////////////////////////////////

#endif
