/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PerspectiveTabWidget.h
 *    Declaration of the PerspectiveTabBar.
 *
 * @author Erik Einhorn
 * @date   2010/12/15
 */

#ifndef _MIRA_PERSPECTIVETABWIDGET_H_
#define _MIRA_PERSPECTIVETABWIDGET_H_

#include <QWidget>
#include <QTabBar>

#include <rcp/Workbench.h>

class QMenu;
class QMenuBar;
class QPushButton;

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class PerspectiveTabBar : public QTabBar
{
	Q_OBJECT
public:
	PerspectiveTabBar(QWidget* parent) ;

signals:

	void tabEditRequested(int);

protected slots:

	void menuDelete();
	void menuEdit();

protected:
	void mousePressEvent(QMouseEvent* event);

private:
	QMenu* mPopupMenu;
	QAction* mDeleteAction;
	int mCurrentIndexForMenu;
};

///////////////////////////////////////////////////////////////////////////////

class PerspectiveTabWidget : public QWidget
{
	Q_OBJECT
public:
	typedef Workbench::Perspective Perspective;

	PerspectiveTabWidget(QMenuBar* menuBar);

public:

	virtual QSize sizeHint() const;

public slots:

	void activatePerspective(Perspective* perspective);
	void addPerspective(Perspective* perspective);
	void removePerspective(Perspective* perspective);

signals:

	void changedPerspective(Perspective*);
	void movedPerspective(int from, int to);
	void renamedPerspective(Perspective*, QString);
	void onAddPerspectiveRequested(std::string);
	void onRemovedPerspectiveRequested(Perspective*);

private slots:

	void addPerspective();
	void tabCurrentChanged(int index);
	void tabCloseRequested(int index);
	void tabEditRequested(int index);
	void tabMoved(int from, int to);

private:

	int toIndex(Perspective* perspective);
	Perspective* toPerspective(int index);

private:

	QMenuBar* mMenuBar;
	QTabBar*  mTabBar;
	QPushButton* mTabButton;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif
