/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PageViewPart.h
 *    Declaration of the PageViewPart.
 *
 * @author Erik Einhorn
 * @date   2010/12/30
 */

#ifndef _MIRA_PAGEVIEWPART_H_
#define _MIRA_PAGEVIEWPART_H_

#include <rcp/ViewPart.h>
#include <rcp/PartListener.h>

class QStackedWidget;

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * Special view part for multi-page workbench views.
 *
 * Within the workbench there are many views which track the active part.
 * If a part is activated these views display some properties for the active
 * part. To avoid loss of context when part activation changes, these views
 * may implement a multi-page approach. A separate page is maintained within
 * the view for each source view. If a part is activated the associated page
 * for the part is brought to top.
 *
 * (parts of docu taken from Eclipse Platform API)
 */
class PageViewPart : public ViewPart, protected IPartListener
{

	MIRA_ABSTRACT_OBJECT(PageViewPart)

public:
	PageViewPart();
	virtual ~PageViewPart();

protected:

	/**
	 * Must be implemented in derived classes.
	 * Is called to display a default page (e.g. when no workbench part is
	 * active)
	 */
	virtual QWidget* createDefaultPage() = 0;

	/**
	 * Must be implemented in derived classes.
	 * Is called when the workbench part changes in order to display a
	 * special page for that part.
	 * If this method returns NULL, the current page remains unchanged.
	 * Note that the creator of the page is responsible for its destruction.
	 * The page will not be deleted if this PageViewPart is destructed!
	 */
	virtual QWidget* createPage(IWorkbenchPart* part) = 0;

protected:

	/// Creates the content widget
	virtual QWidget* createPartControl();

	/// Sets the specified widget as current "page"
	void setPage(QWidget* page);

protected: // implementation of IPartListener

	virtual void editorActivated(IWorkbenchPart* part);
	virtual void editorClosed(IWorkbenchPart* part);

	virtual void viewActivated(IWorkbenchPart* part);
	virtual void viewClosed(IWorkbenchPart* part);

private:

	QStackedWidget* mContainer;

	QString mOriginalTitle;

	QToolButton* mLock;
};

//////////////////////////////////////////////////////////////////////////////

}

#endif
