/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file ProfilerTest.C
 *    Test cases for Profiler.h (not a unit test).
 *
 * @author Erik Einhorn
 * @date   2010/11/18
 */

// suppress Boost.Test forcing a failure when dot (graphviz) is not available
// (which is actually handled just fine by the tested code, but Boost.Test
//  does not approve with its way of checking: http://stackoverflow.com/questions/5325202/
//  boostunit-test-case-fails-because-a-child-process-exits-with-nonzero)
#define BOOST_TEST_IGNORE_NON_ZERO_CHILD_CODE
#include <boost/test/included/unit_test.hpp>

#define MIRA_PROFILER_ENABLED
#include <utils/Profiler.h>

using namespace mira;

BOOST_AUTO_TEST_CASE(getCyclesTest)
{
	uint64 start = Profiler::getCycleCount();
	std::cout << "start: " << start << std::endl;
	uint64 last = start;
	for(int i=0; i<200; ++i)
	{
		MIRA_SLEEP(10);
		uint64 current = Profiler::getCycleCount();
		std::cout << "current: " << current  << ", delta: " << current-last << std::endl;
		BOOST_CHECK(current>start);
		last=current;
	}
}


BOOST_AUTO_TEST_CASE(fullTest)
{
	MIRA_PROFILE_BEGIN(test)

		int fak = 1;
		for(int j=0; j<10000; ++j)
		{
			MIRA_PROFILE_BEGIN(test2)

			for(int i=1; i<100000; ++i)
				fak *= i;
			MIRA_PROFILE_END(test2)
		}

	MIRA_PROFILE_END(test)
	std::cout << fak << std::endl;

	MIRA_PROFILE_BEGIN(test3)

	MIRA_PROFILE_END(test3)

	Profiler::writeReport("profile","dot");
}
