/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file TypenameTest.C
 *    Endian test cases.
 * @author Tim Langner
 * @date   2010/06/28
 */

#include <boost/test/unit_test.hpp>

#include <iostream>
#include <platform/Endian.h>
#include <math.h>

using namespace mira;
using namespace std;


#define checkEndian(T, value) \
	BOOST_CHECK_EQUAL(networkToHost<T>(hostToNetwork<T>(value)),  value);


#define checkEndianLimits(T) \
	checkEndian(T, numeric_limits<T>::min());      \
	checkEndian(T, numeric_limits<T>::max());      \
	checkEndian(T, numeric_limits<T>::infinity());


BOOST_AUTO_TEST_CASE( testEndian )
{
	checkEndian(bool,true);
	checkEndian(uint8,65);
	checkEndian(uint16,10);
	checkEndian(uint32,10);
	checkEndian(uint64,10);
	checkEndian(int8,65);
	checkEndian(int16,-10);
	checkEndian(int32,-10);
	checkEndian(int64,-10);
	checkEndian(float,-10.10f);
	checkEndian(double,-10.10f);
}


BOOST_AUTO_TEST_CASE( testEndianLimits )
{
	checkEndianLimits(uint8);
	checkEndianLimits(uint16);
	checkEndianLimits(uint32);
	checkEndianLimits(uint64);

	checkEndianLimits(int8);
	checkEndianLimits(int16);
	checkEndianLimits(int32);
	checkEndianLimits(int64);

	checkEndianLimits(float);
	checkEndianLimits(double);
}

BOOST_AUTO_TEST_CASE( testFloatRepresentation )
{
	BOOST_CHECK_EQUAL(hostToNetwork<float>(1.125f),  36927);
}

BOOST_AUTO_TEST_CASE( testDoubleRepresentation )
{
	BOOST_CHECK_EQUAL(hostToNetwork<double>(1.125),  62015);
}

