/*
 * Copyright (C) by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file RegisterLibraryConstructor.C
 *    Library constructor registering library at LibraryRegistry.
 *
 * @author Christof Schröter
 * @date   2020/10/05
 */

#include <factory/LibraryRegistry.h>

namespace mira {

//////////////////////////////////////////////////////////////////////////////

#if defined(LIBRARY_TARGET_NAME) && defined(PACKAGE_VERSION_MAJOR) &&  \
    defined(PACKAGE_VERSION_MINOR) && defined(PACKAGE_VERSION_PATCH)

#define functionName2(NAME, V1, V2, V3) registerLibraryConstructor_##NAME##_##V1##_##V2##_##V3
#define functionName(NAME, V1, V2, V3) functionName2(NAME, V1, V2, V3)

#define Quote2(arg) #arg
#define Quote(arg) Quote2(arg)

/**
 * This will register the library it is compiled into at the LibraryRegistry.
 * It requires compiler definitions for
 * LIBRARY_TARGET_NAME and PACKAGE_VERSION_MAJOR/MINOR/PATCH.
 *
 * This function is marked as a library constructor, it will be executed
 * when the library is loaded. This source file should be added once to each
 * library, preferably by the MIRA_ADD_LIBRARY cmake macro.
 */
void __attribute__ ((constructor)) functionName(LIBRARY_TARGET_NAME, PACKAGE_VERSION_MAJOR, PACKAGE_VERSION_MINOR, PACKAGE_VERSION_PATCH) (void)
// the function needs a unique name, else constructors for different libs and versions are not properly distinguished
{
	mira::LibraryRegistry::registerLibrary(Quote(LIBRARY_TARGET_NAME),
	                                       mira::LibraryVersion(PACKAGE_VERSION_MAJOR,
	                                                            PACKAGE_VERSION_MINOR,
	                                                            PACKAGE_VERSION_PATCH));
}

#else
	#error Need definitions for LIBRARY_TARGET_NAME and PACKAGE_VERSION_MAJOR/MINOR/PATCH. Please fix package and/or make system.
#endif

//////////////////////////////////////////////////////////////////////////////

} // namespace
