/*
 * Copyright (C) 2025 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file IMacro.h
 *    Interface for implementing XML macros.
 *
 * @author Adrian Kriegel
 * @date   Fri Jan 17 2025
 */

#ifndef _MIRA_XML_MACROS_IXML_MACRO_H_
#define _MIRA_XML_MACROS_IXML_MACRO_H_

#include <memory>

#include <ostream>
#include <xml/XMLDom.h>

#include <xml/macros/Types.h>

namespace mira {

// f.d.
class XMLMacroProcessor;

} // namespace mira

namespace mira::xmlmacros {

/**
 * Interface for implementing macro definitions.
 */
class IMacro
{
public:
	template<typename Reflector>
	void reflect(Reflector& r)
	{}

	/**
	 * Expands the macro.
	 * @param ioNode Node to expand in-place.
	 * @returns an iterator to the next node to process.
	 */
	virtual XMLNode expand(XMLMacroProcessor&, XMLNode ioNode) = 0;

	/** @returns true of toString is implemented. */
	[[nodiscard]] virtual bool canCoerceToString() const
	{
		return false;
	}

	virtual void coerceToString(XMLMacroProcessor&, std::ostream&) {}

	[[nodiscard]] virtual std::optional<SourceInfo> getSource() const {
		return std::nullopt;
	}

	virtual ~IMacro() = default;

}; // class IMacro

using MacroPtr = std::shared_ptr<IMacro>;

}; // namespace mira::xmlmacros

#endif // _MIRA_XML_MACROS_IXML_MACRO_H_
