/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file Tools.C
 *    Implementation of Tools.h.
 *
 * @author Ronny Stricker
 * @date   2012/12/03
 */
#include "core/Tools.h"

#include <utils/Foreach.h>
#include <utils/PathFinder.h>

using namespace std;

namespace mira {

///////////////////////////////////////////////////////////////////////////////

QAppExist::QAppExist()
{
	mAppExist = false;
}

bool QAppExist::get()
{
	return instance().mAppExist;
}

void QAppExist::set( bool value )
{
	instance().mAppExist = value;
}

///////////////////////////////////////////////////////////////////////////////

PathProvider::PathProvider()
{
	checkForMIRAPath();
	mMiraPaths = extractPaths("$MIRA_PATH");
}

/**
 * @brief return MIRA_PATH variable.
 */
PathVector PathProvider::miraPaths()
{
	return instance().mMiraPaths;
}

/**
 * @brief return the MIRA_PATH variable which is contained in the given path.
 * Tries to match the beginning of the given path with every MIRA_PATH variable.
 * Returns an empty path if no match can be found.
 */
Path PathProvider::getAssociatedMiraPath( Path const& path )
{
	Path bestMatch;
	uint32 bestMatchLength = 0;
	foreach( Path const& miraPath, instance().mMiraPaths ) {
		if ( path.string().find( miraPath.string() ) == 0
				&& miraPath.string().length() > bestMatchLength ) {
			bestMatchLength = miraPath.string().length();
			bestMatch = miraPath;
		}
	}
	return bestMatch;
}

/**
 * @brief calls getAssociatedMiraPath and returns true if a match was found.
 */
bool PathProvider::isMiraSubPath( Path const& path )
{
	return !getAssociatedMiraPath( path ).empty();
}

///////////////////////////////////////////////////////////////////////////////

}
