/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PreferencesDialog.C
 *
 * @author Erik Einhorn
 * @date   2011/12/01
 */

#include <app/PreferencesDialog.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

PreferencesDialog::PreferencesDialog(QWidget* parent, const Preferences& p) :
		QDialog(parent), mPreferences(p)
{
	setupUi(this);

	stackedWidget->setCurrentIndex(0);
	connect(listWidget, SIGNAL(currentRowChanged(int)),
	        stackedWidget, SLOT(setCurrentIndex(int)));

	// translate preferences into gui settings

	mCbAutosave->setChecked(p.autosaveWorkspace);
	mSbAutosave->setValue(p.autosaveWorkspaceInterval);

	mCbHideEditorWindowDecorations->setChecked(p.hideEditorWindowDecorations);

	mCbTopLeftDock->setCurrentIndex(p.corners[Preferences::TopLeft] ? 0 : 1);
	mCbTopRightDock->setCurrentIndex(p.corners[Preferences::TopRight] ? 0 : 1);
	mCbBottomRightDock->setCurrentIndex(p.corners[Preferences::BottomRight] ? 0 : 1);
	mCbBottomLeftDock->setCurrentIndex(p.corners[Preferences::BottomLeft] ? 0 : 1);

	mCbLockWorkspace->setChecked(p.lockWorkspace);

	changedDockSettings();

	mCbOfferAuxiliaryVisualizations->setChecked(p.offerAuxiliaryVisualizations);
}


Preferences PreferencesDialog::getPreferences() const
{
	Preferences p = mPreferences;

	// translate gui settings back to preferences

	p.autosaveWorkspace = mCbAutosave->isChecked();
	p.autosaveWorkspaceInterval = mSbAutosave->value();

	p.hideEditorWindowDecorations = mCbHideEditorWindowDecorations->isChecked();

	p.corners[Preferences::TopLeft]=(mCbTopLeftDock->currentIndex()==0);
	p.corners[Preferences::TopRight]=(mCbTopRightDock->currentIndex()==0);
	p.corners[Preferences::BottomRight]=(mCbBottomRightDock->currentIndex()==0);
	p.corners[Preferences::BottomLeft]=(mCbBottomLeftDock->currentIndex()==0);

	p.lockWorkspace = mCbLockWorkspace->isChecked();

	p.offerAuxiliaryVisualizations = mCbOfferAuxiliaryVisualizations->isChecked();

	return p;
}


void PreferencesDialog::changedDockSettings()
{
	if(mCbTopLeftDock->currentIndex()==0)
		mFrTopLeftDock->setStyleSheet(mFrLeftDock->styleSheet());
	else
		mFrTopLeftDock->setStyleSheet(mFrTopDock->styleSheet());

	if(mCbTopRightDock->currentIndex()==0)
		mFrTopRightDock->setStyleSheet(mFrRightDock->styleSheet());
	else
		mFrTopRightDock->setStyleSheet(mFrTopDock->styleSheet());

	if(mCbBottomRightDock->currentIndex()==0)
		mFrBottomRightDock->setStyleSheet(mFrRightDock->styleSheet());
	else
		mFrBottomRightDock->setStyleSheet(mFrBottomDock->styleSheet());

	if(mCbBottomLeftDock->currentIndex()==0)
		mFrBottomLeftDock->setStyleSheet(mFrLeftDock->styleSheet());
	else
		mFrBottomLeftDock->setStyleSheet(mFrBottomDock->styleSheet());
}


///////////////////////////////////////////////////////////////////////////////

} // namespace

