/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file MIRACenter.h
 *    Description.
 *
 * @author Erik Einhorn
 * @date   2010/12/01
 */

#ifndef _MIRA_MIRACENTER_H_
#define _MIRA_MIRACENTER_H_

//#include <rcp/RCPView.h>

#include <ui_MIRACenter.h>

#include <serialization/adapters/std/list>
#include <platform/Memory.h>
#include <utils/Singleton.h>
#include <utils/Path.h>
#include <rcp/Workbench.h>

#include <fw/FrameworkWithGui.h>

#include <app/Preferences.h>

#include <widgets/SplashScreen.h>

class QTimerEvent;

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class MIRACenter : public Workbench,
                   public ExplicitSingleton<MIRACenter>,
                   protected Ui::MIRACenter
{
	Q_OBJECT
public:
	MIRACenter();
	virtual ~MIRACenter();

public:

	template <typename Reflector>
	void reflect(Reflector& r)
	{
		r.member("Preferences", mPreferences, "", Preferences());
		MIRA_REFLECT_BASE(r, Workbench);
		r.member("RemoteFrameworkHistory", mRemoteFrameworkHistory, "", std::list<std::string>());
	}

public:

	void setupGUI();

	void saveWorkspace(); // saves workspace under the last used workspace file name (exceptions are ignored)
	virtual void saveWorkspace(const Path& path);
	virtual void loadWorkspace(const Path& path);
	void handleLoadWorkspaceError(const Path& loadPath, bool failed);

public:

	/// Returns the main authority of the application
	Authority& getAuthority() { return mAuthority; }


public slots:

	// file menu
	void fileLoadConfiguration();
	void fileAddRemoteFramework();
	void fileClearWorkspace();
	void fileLoadWorkspace();
	void fileLoadDefaultWorkspace();
	void fileSaveWorkspace();

	// windows menu
	void windowShowView();
	void windowFullscreen(bool fullscreen);
	void windowPreferences();
	void windowEditorShow(EditorPart* editor);
	void windowEditorClose(EditorPart* editor);

	// help menu
	void helpContent();
	void helpIndex();
	void helpKeyboardShortcuts();
	void helpAbout();


	// shortcuts
	void minimizeAllViews();

protected:

	void timerEvent(QTimerEvent* event);
	void closeEvent(QCloseEvent* event);

	void onEditorCreated(EditorPart* editor);
	void onEditorDestroyed(EditorPart* editor);

	void onWindowTitleChanged(EditorPartWindow* window);
	void onEditorWindowActivated(EditorPartWindow* window);

private:

	void populateDefaultPerspectives();
	QWidget* createDefaultPart(const std::string& className);

	void placeViewPart(QWidget* part, Qt::DockWidgetArea area);
	void placeViewParts(QWidget* part1, QWidget* part2, Qt::DockWidgetArea area, Qt::Orientation orientation);
	void placeViewPartTabbed(QWidget* placed, QWidget* part);

	void updateFromPreferences();
	void updateDockCorners();
	void updateStatusBar();

private:

	Authority mAuthority;

	Preferences mPreferences;

private:

	Path mWorkspaceFilePath;

private:

	struct
	{
		bool wasMaximized;
		Qt::DockWidgetAreas restoreViews;
	} mBeforeFullscreenState;

private:

	// history of remote frameworks the user has added
	std::list<std::string> mRemoteFrameworkHistory;
	MemoryUsage mCurrentMemoryUsage;
	float mCurrentCPUUsage;
	std::size_t mCurrentIncomingData;
	std::size_t mCurrentOutgoingData;
	int mResourceTimer;
	int mAutosaveTimer;
	int mStatusBarTimer;

	QAction* mMinimizeAllViews;

	QLabel* mLbTime;
	QLabel* mLbMemoryUsage;
	QLabel* mLbCPUUsage;
	QLabel* mLbNetworkIncomingBytes;
	QLabel* mLbNetworkOutgoingBytes;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif
