/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file GeometryVisualization.C
 *    Text visualizations for standard geometries.
 *
 * @author Tim Langner
 * @date   2011/07/22
 */

#include <geometry/Point.h>
#include <visualization/text/VisualizationTextJSON.h>

namespace mira { namespace gui {

///////////////////////////////////////////////////////////////////////////////

MIRA_JSON_VISUALIZATION(Point2iVisualizationText, Point2i, "Point", "Point2i",
                        "Visualization of 2D integer points", "Geometry")
MIRA_JSON_VISUALIZATION(Point2fVisualizationText, Point2f, "Point", "Point2f",
                        "Visualization of 2D float points", "Geometry")
MIRA_JSON_VISUALIZATION(Point2dVisualizationText, Point2d, "Point", "Point2d",
                        "Visualization of 2D double points", "Geometry")
MIRA_JSON_VISUALIZATION(Point3iVisualizationText, Point3i, "Point", "Point3i",
                        "Visualization of 3D integer points", "Geometry")
MIRA_JSON_VISUALIZATION(Point3fVisualizationText, Point3f, "Point", "Point3f",
                        "Visualization of 3D float points", "Geometry")
MIRA_JSON_VISUALIZATION(Point3dVisualizationText, Point3d, "Point", "Point3d",
                        "Visualization of 3D double points", "Geometry")

///////////////////////////////////////////////////////////////////////////////

}}

MIRA_CLASS_SERIALIZATION(mira::gui::Point2iVisualizationText,
                         mira::VisualizationText);
MIRA_CLASS_SERIALIZATION(mira::gui::Point2fVisualizationText,
                         mira::VisualizationText);
MIRA_CLASS_SERIALIZATION(mira::gui::Point2dVisualizationText,
                         mira::VisualizationText);
MIRA_CLASS_SERIALIZATION(mira::gui::Point3iVisualizationText,
                         mira::VisualizationText);
MIRA_CLASS_SERIALIZATION(mira::gui::Point3fVisualizationText,
                         mira::VisualizationText);
MIRA_CLASS_SERIALIZATION(mira::gui::Point3dVisualizationText,
                         mira::VisualizationText);
