#!/bin/bash

# arguments:
# 1: patch file
# 2: directory (for help message)
# all further arguments are relayed to the call to patch  

patch=$1
dir=$2
shift 2                # discard the first 2 arguments (stored in separate variables above)

patch -f $@ < $patch   # give all remaining arguments to patch (and force non-interactive)

ret=$?

if [ $ret = 1 ]; then
	echo "----------------------------------------------------------------------"
	echo "MIRA maintainer notice:"
	echo "The most common cause for this error is that the build system tries"
	echo "to apply the patch a second time to an already patched file for some"
	echo "reason. A primitive solution is to force a clean download again by"
	echo "removing the respective directory:"
	echo "$dir"
	echo "----------------------------------------------------------------------"
	exit 1
fi

exit $ret


