###############################################################################
# OpenCV
###############################################################################

IF(WIN32)
	###########################################################################
	# On Windows, try to find the installed version of OpenCV based on the
	# environment variable OPENCV_HOME, which must be point the directory,
	# where the file OpenCVConfig.cmake is located.

	# Get path to OpenCV based on the environment variable OGRE_HOME
	SET(OPENCV_HOME $ENV{OPENCV_HOME})

	# Check if the file is called from the root mira environment
	string(COMPARE EQUAL ${MIRA_ROOT_DIR} ${CMAKE_SOURCE_DIR} RootProject)

	IF( NOT OPENCV_HOME )
		#######################################################################
		# We couldn't found ${OPENCV_HOME}.

		IF (${RootProject})
			MESSAGE(STATUS "Can't find environment variable OPENCV_HOME. Using downloads.")

			MIRA_EXTERNAL_PROJECT(OpenCV
				URL http://www.mira-project.org/downloads/3rdparty/bin-win32/OpenCV-2.2.0-win32-msvc2010.zip

				PREFIX       ${MIRA_ROOT_DIR}/external/opencv
				STAMP_DIR    ${MIRA_ROOT_DIR}/external/opencv/cmake
				TMP_DIR      ${MIRA_ROOT_DIR}/external/opencv/cmake
				DOWNLOAD_DIR ${MIRA_ROOT_DIR}/external/opencv
				SOURCE_DIR   ${MIRA_ROOT_DIR}/external/opencv/opencv
				BINARY_DIR   ${MIRA_ROOT_DIR}/external/opencv/opencv
				CONFIGURE_COMMAND "" # no configure step
				BUILD_COMMAND     "" # no build step
				INSTALL_COMMAND   ""
			)
		ENDIF()

		# Since it is problematic to mix ExternalProject_Add and FIND_PACKAGE
		# (FIND_PACKAGE will not work in the config setup, if the external
		# project isn't installed yet), we have handle OpenCV-NOTFOUND
		#FIND_PACKAGE(OpenCV QUIET)
		FIND_PACKAGE(OpenCV CONFIG)

		IF(NOT OpenCV_FOUND)
			MESSAGE(STATUS "OpenCV was found or isn't download yet. Using default settings.")

			SET(OpenCV_DIR ${MIRA_ROOT_DIR}/external/opencv/opencv)
			SET(OPENCV_INCLUDE_DIRS ${OpenCV_DIR}/include ${OpenCV_DIR}/include/opencv)
			SET(OPENCV_LIBRARY_DIRS ${OpenCV_DIR}/lib)
			SET(OPENCV_LIB_COMPONENTS opencv_core opencv_highgui opencv_imgproc)
		ELSE()
			IF(${OpenCV_VERSION} VERSION_LESS "2.2.0")
				MESSAGE(FATAL_ERROR "Need at least OpenCV Version 2.2.0")
			ENDIF()
		ENDIF()

		# Create a linker variable for each OpenCV component
		FOREACH(cvLib ${OPENCV_LIB_COMPONENTS})
			STRING(TOUPPER "${cvLib}" cvLibUpper)
			SET(${cvLibUpper}_LIBRARY "debug;${cvLib}220d;optimized;${cvLib}220")
		ENDFOREACH(cvLib)

		IF (${RootProject})
			IF(${CMAKE_BUILD_TYPE} STREQUAL Debug)
				MIRA_DIST_LIBRARY_EX(OpenCV ${MIRA_ROOT_DIR}/external/opencv/opencv/bin/opencv_core220d.dll)
				MIRA_DIST_LIBRARY_EX(OpenCV ${MIRA_ROOT_DIR}/external/opencv/opencv/bin/opencv_highgui220d.dll)
				MIRA_DIST_LIBRARY_EX(OpenCV ${MIRA_ROOT_DIR}/external/opencv/opencv/bin/opencv_imgproc220d.dll)
			ELSE()
				MIRA_DIST_LIBRARY_EX(OpenCV ${MIRA_ROOT_DIR}/external/opencv/opencv/bin/opencv_core220.dll)
				MIRA_DIST_LIBRARY_EX(OpenCV ${MIRA_ROOT_DIR}/external/opencv/opencv/bin/opencv_highgui220.dll)
				MIRA_DIST_LIBRARY_EX(OpenCV ${MIRA_ROOT_DIR}/external/opencv/opencv/bin/opencv_imgproc220.dll)
			ENDIF()

			MIRA_INSTALL(
				DIRECTORY ${MIRA_ROOT_DIR}/external/opencv/opencv/include
				DESTINATION external/opencv/opencv
				PACKAGE external
				FILES_MATCHING
				PATTERN "*"
				PATTERN ".svn" EXCLUDE
			)

			MIRA_INSTALL(
				DIRECTORY ${MIRA_ROOT_DIR}/external/opencv/opencv/lib
				DESTINATION .
				PACKAGE external
				FILES_MATCHING
				PATTERN "*.lib"
			)

			MIRA_INSTALL(
				DIRECTORY ${MIRA_ROOT_DIR}/external/opencv/opencv/bin
				DESTINATION .
				PACKAGE external
				FILES_MATCHING
				PATTERN "*.dll"
			)
		ENDIF()

	ELSE(NOT OPENCV_HOME)
		#######################################################################
		# Try to locate OpenCV based on ${OPENCV_HOME}.

		MESSAGE(STATUS "Try to locate OpenCV based on environment variable OPENCV_HOME.")

		set(OpenCV_DIR ${OPENCV_HOME})
		FIND_PACKAGE(OpenCV REQUIRED)
		
		IF(${OpenCV_VERSION} VERSION_LESS "2.2.0")
			MESSAGE(FATAL_ERROR "Need at least OpenCV Version 2.2.0")
		ENDIF()

		SET(OPENCV_INCLUDE_DIRS ${OpenCV_INCLUDE_DIRS})
		SET(OPENCV_LIBRARY_DIRS ${OpenCV_LIB_DIR})

		# fix for opencv >= 2.3 where OPENCV_LIB_COMPONENTS is renamed into OpenCV_LIB_COMPONENTS
		if(${OpenCV_VERSION} VERSION_GREATER "2.2.0")
			SET(OPENCV_LIB_COMPONENTS ${OpenCV_LIB_COMPONENTS})
		endif()

		# Create a linker variable for each OpenCV component
		IF (CMAKE_VERBOSE_MAKEFILE)
			MESSAGE(STATUS "Found following OpenCV components:")
		ENDIF()
		SET(versionStr ${OpenCV_VERSION_MAJOR}${OpenCV_VERSION_MINOR}${OpenCV_VERSION_PATCH})
		FOREACH(cvLib ${OPENCV_LIB_COMPONENTS})
			IF(OpenCV_USE_MANGLED_PATHS)
				# In this case, ${cvLib} is a full file name to the shared library.
				# Therefore, we have to extract the actual name of the component.
				GET_FILENAME_COMPONENT(baseName ${cvLib} NAME_WE)

				# Remove the "lib" prefix
				STRING(SUBSTRING ${baseName} 0 3 libPrefix)
				IF(${libPrefix} STREQUAL "lib")
					STRING(SUBSTRING ${baseName} 3 -1 baseName)
				ENDIF()
				STRING(TOUPPER "${baseName}" baseNameUpper)
				SET(${baseNameUpper}_LIBRARY "debug;${cvLib}${versionStr}d;optimized;${cvLib}${versionStr}")
				IF (CMAKE_VERBOSE_MAKEFILE)
					MESSAGE(STATUS "   ${baseNameUpper}_LIBRARY -> ${cvLib}")
				ENDIF()
			ELSE()
				# In this case, ${cvLib} is just the name of the component. So we
				# simply can use it.
				STRING(TOUPPER "${cvLib}" cvLibUpper)
				SET(${cvLibUpper}_LIBRARY "debug;${cvLib}${versionStr}d;optimized;${cvLib}${versionStr}")
				IF (CMAKE_VERBOSE_MAKEFILE)
					MESSAGE(STATUS "   ${cvLibUpper}_LIBRARY -> ${${cvLibUpper}_LIBRARY}")
				ENDIF()
			ENDIF()
		ENDFOREACH(cvLib)

		# Ensure, that the necessary OpenCV DLL's are copied to MIRA/bin
		ADD_CUSTOM_TARGET(OpenCV)

		IF (${RootProject})
			IF(${CMAKE_BUILD_TYPE} STREQUAL Debug)
				GET_FILENAME_COMPONENT(dllPath "${OpenCV_LIB_DIR_DBG}/../bin" ABSOLUTE) 
				MIRA_DIST_LIBRARY_EX(OpenCV "${dllPath}/opencv_core${versionStr}d.dll")
				MIRA_DIST_LIBRARY_EX(OpenCV "${dllPath}/opencv_highgui${versionStr}d.dll")
				MIRA_DIST_LIBRARY_EX(OpenCV "${dllPath}/opencv_imgproc${versionStr}d.dll")
			ELSE()
				GET_FILENAME_COMPONENT(dllPath "${OpenCV_LIB_DIR_OPT}/../bin" ABSOLUTE) 
				MIRA_DIST_LIBRARY_EX(OpenCV "${dllPath}/opencv_core${versionStr}.dll")
				MIRA_DIST_LIBRARY_EX(OpenCV "${dllPath}/opencv_highgui${versionStr}.dll")
				MIRA_DIST_LIBRARY_EX(OpenCV "${dllPath}/opencv_imgproc${versionStr}.dll")
			ENDIF()
		ENDIF()

	ENDIF()

ELSE(WIN32)

	FIND_PACKAGE(OpenCV REQUIRED)

	IF(${OpenCV_VERSION} VERSION_LESS "2.2.0")
		MESSAGE(FATAL_ERROR "Need at least OpenCV Version 2.2.0")
	ENDIF()

	SET(OPENCV_INCLUDE_DIRS ${OpenCV_INCLUDE_DIRS})
	SET(OPENCV_LIBRARY_DIRS ${OpenCV_LIB_DIR})

	# fix for opencv >=2.3 where OPENCV_LIB_COMPONENTS is renamed into OpenCV_LIB_COMPONENTS
	if(${OpenCV_VERSION} VERSION_GREATER "2.2.0")
		SET(OPENCV_LIB_COMPONENTS ${OpenCV_LIB_COMPONENTS})
	endif()

	# Create a linker variable for each OpenCV component
	IF (CMAKE_VERBOSE_MAKEFILE)
		MESSAGE(STATUS "Found following OpenCV components:")
	ENDIF()
	FOREACH(cvLib ${OPENCV_LIB_COMPONENTS})
		IF(OpenCV_USE_MANGLED_PATHS)
			# In this case, ${cvLib} is a full file name to the shared library.
			# Therefore, we have to extract the actual name of the component.
			GET_FILENAME_COMPONENT(baseName ${cvLib} NAME_WE)

			# Remove the "lib" prefix
			STRING(SUBSTRING ${baseName} 0 3 libPrefix)
			IF(${libPrefix} STREQUAL "lib")
				STRING(SUBSTRING ${baseName} 3 -1 baseName)
			ENDIF()
			STRING(TOUPPER "${baseName}" baseNameUpper)
			SET(${baseNameUpper}_LIBRARY "${cvLib}")
			IF (CMAKE_VERBOSE_MAKEFILE)
				MESSAGE(STATUS "   ${baseNameUpper}_LIBRARY -> ${cvLib}")
			ENDIF()
		ELSE()
			# In this case, ${cvLib} is just the name of the component. So we
			# simply can use it.
			STRING(TOUPPER "${cvLib}" cvLibUpper)
			SET(${cvLibUpper}_LIBRARY "${cvLib}")
			IF (CMAKE_VERBOSE_MAKEFILE)
				MESSAGE(STATUS "   ${cvLibUpper}_LIBRARY -> ${cvLib}")
			ENDIF()
		ENDIF()
	ENDFOREACH(cvLib)

ENDIF(WIN32)

###############################################################################

IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "OPENCV")
	MESSAGE(STATUS "   incdir   = " ${OPENCV_INCLUDE_DIRS})
	MESSAGE(STATUS "   libdir   = " ${OPENCV_LIBRARY_DIRS})
ENDIF (CMAKE_VERBOSE_MAKEFILE)
