###############################################################################
# LibXML2
###############################################################################

IF(WIN32)
	# On Windows, download libxml2

	if(CMAKE_SIZEOF_VOID_P EQUAL 8)
		set(LIBXML2_URL "http://www.mira-project.org/downloads/3rdparty/bin-win64/libxml2-2.7.8.win64.zip" )
	else()
		set(LIBXML2_URL "http://www.mira-project.org/downloads/3rdparty/bin-win32/libxml2-2.7.6.win32.zip" )
	endif()

	MIRA_EXTERNAL_PROJECT(XML2
		URL ${LIBXML2_URL}

		PREFIX       ${MIRA_ROOT_DIR}/external/xml2
		STAMP_DIR    ${MIRA_ROOT_DIR}/external/xml2/cmake
		TMP_DIR      ${MIRA_ROOT_DIR}/external/xml2/cmake
		DOWNLOAD_DIR ${MIRA_ROOT_DIR}/external/xml2
		SOURCE_DIR   ${MIRA_ROOT_DIR}/external/xml2/xml2
		BINARY_DIR   ${MIRA_ROOT_DIR}/external/xml2/xml2
		CONFIGURE_COMMAND "" # no configure step
		BUILD_COMMAND     "" # no build step
		INSTALL_COMMAND   "" # no install step
	)

	SET(LIBXML2_INCLUDE_DIRS
		"${MIRA_ROOT_DIR}/external/xml2/xml2/include"
	)

	SET(LIBXML2_LIBRARY_DIRS
		"${MIRA_ROOT_DIR}/external/xml2/xml2/lib"
	)

	SET(LIBXML2_LIBRARIES
		"libxml2"
	)

	MIRA_DIST_LIBRARY_EX(XML2 ${MIRA_ROOT_DIR}/external/xml2/xml2/bin/libxml2.dll)

	MIRA_INSTALL(
		DIRECTORY ${MIRA_ROOT_DIR}/external/xml2/xml2/include
		DESTINATION external/xml2/xml2
		PACKAGE external
		FILES_MATCHING
		PATTERN "*"
		PATTERN ".svn" EXCLUDE
	)

	MIRA_INSTALL(
		DIRECTORY ${MIRA_ROOT_DIR}/external/xml2/xml2/lib
		DESTINATION .
		PACKAGE external
		FILES_MATCHING
		PATTERN "*.lib"
	)

	MIRA_INSTALL(
		DIRECTORY ${MIRA_ROOT_DIR}/external/xml2/xml2/bin
		DESTINATION .
		PACKAGE external
		FILES_MATCHING
		PATTERN "*.dll"
	)

ELSE(WIN32)
	# On Linux, use pkg-config to get libxml2 settings

	pkg_check_modules(LIBXML2 REQUIRED libxml-2.0)

ENDIF(WIN32)

###############################################################################

IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "LIBXML2")
	MESSAGE(STATUS "   incdir = " ${LIBXML2_INCLUDE_DIRS})
	MESSAGE(STATUS "   libdir = " ${LIBXML2_LIBRARY_DIRS})
	MESSAGE(STATUS "   libs   = " ${LIBXML2_LIBRARIES})
ENDIF (CMAKE_VERBOSE_MAKEFILE)
