###############################################################################
# BZip2
###############################################################################

IF(WIN32)
	# On Windows, download bzip2

	if(CMAKE_SIZEOF_VOID_P EQUAL 8)
		set(BZIP2_URL "http://www.mira-project.org/downloads/3rdparty/bin-win64/bzip2-1.0.6.win64.zip" )
	else()
		set(BZIP2_URL "http://www.mira-project.org/downloads/3rdparty/bin-win32/bzip2-1.0.6.win32.zip" )
	endif()

	MIRA_EXTERNAL_PROJECT(BZip2
		URL ${BZIP2_URL}

		PREFIX       ${MIRA_ROOT_DIR}/external/bzip2
		STAMP_DIR    ${MIRA_ROOT_DIR}/external/bzip2/cmake
		TMP_DIR      ${MIRA_ROOT_DIR}/external/bzip2/cmake
		DOWNLOAD_DIR ${MIRA_ROOT_DIR}/external/bzip2
		SOURCE_DIR   ${MIRA_ROOT_DIR}/external/bzip2/bzip2
		BINARY_DIR   ${MIRA_ROOT_DIR}/external/bzip2/bzip2
		CONFIGURE_COMMAND "" # no configure step
		BUILD_COMMAND     "" # no build step
		INSTALL_COMMAND   "" # no install step
	)

	SET(BZIP2_INCLUDE_DIRS
		"${MIRA_ROOT_DIR}/external/bzip2/bzip2/include"
	)

	SET(BZIP2_LIBRARY_DIRS
		"${MIRA_ROOT_DIR}/external/bzip2/bzip2/bin"
	)

	SET(BZIP2_LIBRARIES
		"libbz2.dll"
	)

	MIRA_DIST_LIBRARY_EX(BZip2 ${MIRA_ROOT_DIR}/external/bzip2/bzip2/bin/libbz2.dll)

	MIRA_INSTALL(
		DIRECTORY ${MIRA_ROOT_DIR}/external/bzip2/bzip2/include
		DESTINATION external/bzip2/bzip2
		PACKAGE external
		FILES_MATCHING
		PATTERN "*"
		PATTERN ".svn" EXCLUDE
	)

	MIRA_INSTALL(
		DIRECTORY ${MIRA_ROOT_DIR}/external/bzip2/bzip2/bin
		DESTINATION .
		PACKAGE external
		FILES_MATCHING
		PATTERN "*.lib"
	)

	MIRA_INSTALL(
		FILES ${MIRA_ROOT_DIR}/external/bzip2/bzip2/bin/libbz2.dll
		DESTINATION bin
		PACKAGE external
	)

ELSE(WIN32)
	# On Linux, bzip2 is part of the standard includes

	SET(BZIP2_INCLUDE_DIRS "")
	SET(BZIP2_LIBRARY_DIRS "")
	SET(BZIP2_LIBRARIES    "bz2")

ENDIF(WIN32)

###############################################################################

IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "Bzip2")
	MESSAGE(STATUS "   incdir = " ${BZIP2_INCLUDE_DIRS})
	MESSAGE(STATUS "   libdir = " ${BZIP2_LIBRARY_DIRS})
	MESSAGE(STATUS "   libs   = " ${BZIP2_LIBRARIES})
ENDIF (CMAKE_VERBOSE_MAKEFILE)
