###############################################################################
# FreeType
###############################################################################

IF(WIN32)
	# On Win32, download FreeType

	SET(FREETYPE_INSTALL_SRC  ${MIRA_ROOT_DIR}/external/freetype/freetype/bin)
	SET(FREETYPE_INSTALL_DEST ${MIRA_ROOT_DIR}/lib)
	SET(FREETYPE_INSTALL_CMD
		${CMAKE_COMMAND} -E make_directory ${LIB_DIST_ROOT_DIR}
		"&&"
		${CMAKE_COMMAND} -E copy ${FREETYPE_INSTALL_SRC}/freetype6.dll ${LIB_DIST_ROOT_DIR}
	)

	MIRA_EXTERNAL_PROJECT(FreeType
		URL http://www.mira-project.org/downloads/3rdparty/bin-win32/freetype-2.3.5-1.win32.zip

		PREFIX       ${MIRA_ROOT_DIR}/external/freetype
		STAMP_DIR    ${MIRA_ROOT_DIR}/external/freetype/cmake
		TMP_DIR      ${MIRA_ROOT_DIR}/external/freetype/cmake
		DOWNLOAD_DIR ${MIRA_ROOT_DIR}/external/freetype
		SOURCE_DIR   ${MIRA_ROOT_DIR}/external/freetype/freetype
		BINARY_DIR   ${MIRA_ROOT_DIR}/external/freetype/freetype
		CONFIGURE_COMMAND "" # no configure step
		BUILD_COMMAND     "" # no build step
		INSTALL_COMMAND   ${FREETYPE_INSTALL_CMD}
	)

	SET(FREETYPE_INCLUDE_DIRS
		"${MIRA_ROOT_DIR}/external/freetype/freetype/include"
	)

	SET(FREETYPE_LIBRARY_DIRS
		"${MIRA_ROOT_DIR}/external/freetype/freetype/lib"
	)

	SET(FREETYPE_LIBRARIES
		"freetype"
	)

ELSE(WIN32)
	# On Linux, use pkg-config to get freetype settings

	pkg_check_modules(FREETYPE REQUIRED freetype2)

ENDIF(WIN32)

###############################################################################

IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "FREETYPE")
	MESSAGE(STATUS "   incdir = " ${FREETYPE_INCLUDE_DIRS})
	MESSAGE(STATUS "   libdir = " ${FREETYPE_LIBRARY_DIRS})
	MESSAGE(STATUS "   libs   = " ${FREETYPE_LIBRARIES})
ENDIF (CMAKE_VERBOSE_MAKEFILE)
