###############################################################################
# Eigen C++ Math Template-Library
###############################################################################

# We need CMake3 for Eigen >= 3.4.0
if (${CMAKE_VERSION} VERSION_LESS "3.0.0")
	set(CMAKE3_CMD "cmake3")
else()
	set(CMAKE3_CMD ${CMAKE_COMMAND})
endif()


MIRA_EXTERNAL_PROJECT(Eigen
#	URL http://www.mira-project.org/downloads/3rdparty/src/eigen-3.1.2.tar.gz
#	URL http://bitbucket.org/eigen/eigen/get/3.2.0.tar.bz2
#	URL http://www.mira-project.org/downloads/3rdparty/src/eigen-3.2.0.tar.gz
#	URL http://www.mira-project.org/downloads/3rdparty/src/eigen-3.2.1.tar.bz2
#	URL http://www.mira-project.org/downloads/3rdparty/src/eigen-3.3.5.tar.bz2
	URL https://www.mira-project.org/downloads/3rdparty/src/eigen-3.4.0.tar.bz2

	PREFIX        ${MIRA_ROOT_DIR}/external/eigen
	STAMP_DIR     ${MIRA_ROOT_DIR}/external/eigen/cmake
	TMP_DIR       ${MIRA_ROOT_DIR}/external/eigen/cmake
	DOWNLOAD_DIR  ${MIRA_ROOT_DIR}/external/eigen
	SOURCE_DIR    ${MIRA_ROOT_DIR}/external/eigen/eigen-3.4.0
	BINARY_DIR    ${MIRA_ROOT_DIR}/external/eigen/build
	CMAKE_COMMAND ${CMAKE3_CMD}
	CMAKE_ARGS
		-DCMAKE_INSTALL_PREFIX=${MIRA_ROOT_DIR}/external/eigen
		-DBUILD_TESTING=OFF
)

###############################################################################

IF(WIN32)

	# Don't care about vectorization in eigen, until we find a better solution
	# (see http://eigen.tuxfamily.org/dox/UnalignedArrayAssert.html).
	ADD_DEFINITIONS(-DEIGEN_DONT_VECTORIZE)
	ADD_DEFINITIONS(-DEIGEN_DISABLE_UNALIGNED_ARRAY_ASSERT)

	# Disable Eigen alignment completely, since this leads to compiler errors.
	ADD_DEFINITIONS(-DEIGEN_DONT_ALIGN)

ENDIF()

###############################################################################

# Set cmake configuration dir
SET(EIGEN_CMAKE_DIR "${MIRA_ROOT_DIR}/external/eigen/share/eigen3/cmake")

# Set the eigen include dir
SET(EIGEN_INCLUDE_DIRS "${MIRA_ROOT_DIR}/external/eigen/include/eigen3")

IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "Eigen")
	MESSAGE(STATUS "   incdir = " ${EIGEN_INCLUDE_DIRS})
ENDIF (CMAKE_VERBOSE_MAKEFILE)

###############################################################################

MIRA_INSTALL(
	DIRECTORY ${MIRA_ROOT_DIR}/external/eigen/include
	DESTINATION external/eigen
	PACKAGE external
	FILES_MATCHING
	PATTERN "*"
)

MIRA_INSTALL(
	DIRECTORY ${MIRA_ROOT_DIR}/external/eigen/share
	DESTINATION external/eigen
	PACKAGE external
	FILES_MATCHING
	PATTERN "*"
	# Don't install pkgconfig/eigen3.pc, since this contains the absolute
	# path to the Eigen3 installation on the build system.
	PATTERN "pkgconfig" EXCLUDE
)
