###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Provides macro for creating and populating the "in source" Makefile  
# in each source subdirectory.
#
# author: Erik Einhorn
#
###############################################################################

MACRO(INSOURCE_MAKEFILE)
	FILE(WRITE  Makefile "# DO NOT EDIT THIS FILE ! It was generated automatically and all changes\n")
	FILE(APPEND Makefile "# will get lost up on the next invocation of cmake.\n")
	FILE(APPEND Makefile "TOP_DIR=${CMAKE_HOME_DIRECTORY}\n")
	FILE(APPEND Makefile "MIRA_MAKE_DIR=${MIRA_MAKE_DIR}\n")
	FILE(APPEND Makefile "-include $(MIRA_MAKE_DIR)/Insource.make")

	IF(IS_DIRECTORY "${CMAKE_CURRENT_SOURCE_DIR}/.svn")

		# obtain current svn ignores
		EXECUTE_PROCESS(COMMAND svn propget svn:ignore ${CMAKE_CURRENT_SOURCE_DIR}
		                RESULT_VARIABLE result
		                OUTPUT_VARIABLE svnignores
		                OUTPUT_STRIP_TRAILING_WHITESPACE)

		SET(makefileRegex "([\r\t\n ]Makefile[\r\t\n ])|(^Makefile[\r\t\n ])|([\r\t\n ]Makefile$)|(^Makefile$)")

		IF(${result} EQUAL 0)
			# append "Makefile" to the svn ignores, if it is not yet there
			STRING(LENGTH "${svnignores}" svnignores_length)

			# do we have any svn:ignore yet?
			IF(${svnignores_length} EQUAL 0)

				# no!, so add the first svn ignore as "Makefile"
				SET(svnignores "Makefile")

				# set the new svn ignores
				EXECUTE_PROCESS(COMMAND svn propset svn:ignore ${svnignores}
				                ${CMAKE_CURRENT_SOURCE_DIR})

			ELSE (${svnignores_length} EQUAL 0)

				# otherwise, we have some svn:ignores yet, so check if there is a "Makefile" in it
				# already
				IF(NOT ${svnignores} MATCHES ${makefileRegex})
					#MESSAGE("NOT FOUND: ${svnignores}")
					# no "Makefile" yet, so add it at the end
					SET(svnignores "${svnignores}\nMakefile")

					# set the new svn ignores
					EXECUTE_PROCESS(COMMAND svn propset svn:ignore ${svnignores}
					                ${CMAKE_CURRENT_SOURCE_DIR})
				ELSE(NOT ${svnignores} MATCHES ${makefileRegex})
					#MESSAGE("FOUND: ${svnignores}") 
				ENDIF(NOT ${svnignores} MATCHES ${makefileRegex})

			ENDIF(${svnignores_length} EQUAL 0)

		ENDIF(${result} EQUAL 0)

	ENDIF(IS_DIRECTORY "${CMAKE_CURRENT_SOURCE_DIR}/.svn")

ENDMACRO(INSOURCE_MAKEFILE)

