###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Stand-alone script that is called during doc-target build.
# The script collects all documentations of domains and toolboxes.
# Names of the packages and the locations of the associated index.html files
# are added to a "availableDocs.json" file.
#
# Author: Ronny Stricker
#
###############################################################################

MESSAGE(STATUS "Start collecting package documentations")
# extract mira_path entries from environment
STRING(REPLACE ":" ";" MIRA_PATH $ENV{MIRA_PATH})

# start write name and location list in json syntax
SET(JSON_DOC_LOCATIONS "{")

SET(FIRST_LOCATION TRUE)
# cycle through domains and toolboxes
FOREACH(doc_location domains;toolboxes)
	IF(NOT FIRST_LOCATION)
		SET(JSON_DOC_LOCATIONS "${JSON_DOC_LOCATIONS},")		
	ENDIF()
	SET(JSON_DOC_LOCATIONS "${JSON_DOC_LOCATIONS}\"${doc_location}\":[")

	SET(FIRST_DOC TRUE)
	# search in every entry of the mira path
	FOREACH(doc_searchPath ${MIRA_PATH})
		FILE(GLOB_RECURSE MIRA_ALL_DOCS "${doc_searchPath}/doc/${doc_location}/*/index.html")
		FOREACH(doc_fullPath ${MIRA_ALL_DOCS})
			# extract package name and directory that contains the index.html
			GET_FILENAME_COMPONENT(docDir ${doc_fullPath} DIRECTORY)
			GET_FILENAME_COMPONENT(docName ${docDir} NAME)

			IF(NOT FIRST_DOC)
				SET(JSON_DOC_LOCATIONS "${JSON_DOC_LOCATIONS},")		
			ENDIF()
			SET(JSON_DOC_LOCATIONS "${JSON_DOC_LOCATIONS}\"${docName}\",\"${docDir}\"")
			SET(FIRST_DOC FALSE)
		ENDFOREACH(doc_fullPath)
	ENDFOREACH(doc_searchPath)
	SET(JSON_DOC_LOCATIONS "${JSON_DOC_LOCATIONS}]")
	SET(FIRST_LOCATION FALSE)
ENDFOREACH(doc_location)
SET(JSON_DOC_LOCATIONS "${JSON_DOC_LOCATIONS}}")

# write json file
FILE(WRITE "${MIRA_ROOT_DIR}/doc/availableDocs.json" ${JSON_DOC_LOCATIONS})

MESSAGE(STATUS "Finished looking for package documentations")
