###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################

INCLUDE(ExternalProject)

###############################################################################

FUNCTION(GET_ASSOCIATED_MIRA_PATH path result)

	# extract the associated MIRA_PATH
	SET(associatedMIRAPath "")
	SET(matchLength 0)

	STRING(LENGTH ${path} pathLength)

	# extract longest matching MIRA_PATH
	foreach(CurrentMIRAPath ${MIRA_PATH})
		STRING(LENGTH ${CurrentMIRAPath} CurrentMIRAPathLength)
		IF (NOT pathLength LESS CurrentMIRAPathLength)
			STRING(SUBSTRING ${path} 0 ${CurrentMIRAPathLength} MIRAPathCandidate)
			IF( ${MIRAPathCandidate} STREQUAL ${CurrentMIRAPath} )
				IF ( CurrentMIRAPathLength GREATER matchLength )
					SET(associatedMIRAPath ${MIRAPathCandidate})
					SET(matchLength ${CurrentMIRAPathLength})
					#MESSAGE("Found")
					#MESSAGE("matchLenght: ${matchLength}")
				ENDIF()
			ENDIF()
		ENDIF()
	endforeach(CurrentMIRAPath)
	#MESSAGE("Associated MIRA path for external dep ${name}: ${associatedMIRAPath}")

	SET(${result} ${associatedMIRAPath} PARENT_SCOPE)

ENDFUNCTION(GET_ASSOCIATED_MIRA_PATH)

###############################################################################

FUNCTION(MIRA_EXTERNAL_PROJECT name)

	###########################################################################
	# Parse the macro arguments

	CMAKE_PARSE_ARGUMENTS(arg
		# options:
		""
		# one-value arguments:
		"ROOT_DIR;DEPENDS;PREFIX;LIST_SEPARATOR;TMP_DIR;STAMP_DIR;DOWNLOAD_DIR;DOWNLOAD_COMMAND;CVS_REPOSITORY;CVS_MODULE;CVS_TAG;SVN_REPOSITORY;SVN_REVISION;SVN_USERNAME;SVN_PASSWORD;GIT_REPOSITORY;GIT_TAG;URL;URL_MD5;TIMEOUT;UPDATE_COMMAND;PATCH_COMMAND;SOURCE_DIR;CONFIGURE_COMMAND;CMAKE_COMMAND;CMAKE_GENERATOR;CMAKE_ARGS;CMAKE_CACHE;BINARY_DIR;BUILD_COMMAND;BUILD_IN_SOURCE;INSTALL_DIR;INSTALL_COMMAND;TEST_BEFORE_INSTALL;TEST_AFTER_INSTALL;TEST_COMMAND;LOG_DOWNLOAD;LOG_UPDATE;LOG_CONFIGURE;LOG_BUILD;STEP_TARGETS"
		# multi-value arguments:
		""
		${ARGN})

	###########################################################################

	# section for backward compatibility
	IF (NOT arg_ROOT_DIR)

		# Test, if the external project $name is defined within the current cmake project
		STRING(LENGTH ${CMAKE_SOURCE_DIR} srcLen)
		STRING(LENGTH ${CMAKE_CURRENT_LIST_FILE} curListFileLen)

		SET(external_is_in_current_project 0)

		IF(srcLen LESS curListFileLen)
			STRING(SUBSTRING ${CMAKE_CURRENT_LIST_FILE} 0 ${srcLen} currentStart)
		
			IF (${CMAKE_SOURCE_DIR} STREQUAL ${currentStart})
				SET(external_is_in_current_project 1)
			ENDIF()
		ENDIF()

		# Only add the external project, if it is part of the current cmake project
		# and if it has not been added yet.
		IF(${external_is_in_current_project} AND NOT TARGET ${name})
			IF ( DEFINED MIRA_GEN_MANIFESTS_ONLY )
				# add empty target
				add_custom_target( ${name} )
			ELSE()
				ExternalProject_Add(${name} "${ARGN}")
			ENDIF()
		ENDIF()

	ELSE(NOT arg_ROOT_DIR)
		# this sections checks if the root install path exists (rather than checking if the macro is used from the mira-path where the package is located)

		# we dont have to do anything if the target is already known
		IF( NOT TARGET ${name})

			# extract the associated MIRA_PATH
			GET_ASSOCIATED_MIRA_PATH( ${CMAKE_CURRENT_LIST_FILE} associatedMIRAPath )

			SET( ${name}_ROOT_DIR "${associatedMIRAPath}/${arg_ROOT_DIR}" CACHE INTERNAL "" FORCE)
			# we have to check if the directory exists
			IF ((NOT EXISTS "${associatedMIRAPath}/${arg_ROOT_DIR}/") AND (NOT DEFINED MIRA_GEN_MANIFESTS_ONLY))
				# directory does not exist -> install the external project
				# replace all occurences of {name}_ROOT_DIR with the destination directory of the library
				STRING(REGEX REPLACE "${name}_ROOT_DIR" "${${name}_ROOT_DIR}" replacedARGN "${ARGN}")
				# remove the ROOT_DIR Argument because the ExternalProject_Add macro compains otherwise
				STRING(REGEX REPLACE "ROOT_DIR;[^;]*;" "" reducedARGN "${replacedARGN}")
				#MESSAGE("Args: ${reducedARGN}")

				ExternalProject_Add(${name} "${reducedARGN}")
			ELSE()
				# directory allready exists -> only add empty target
				add_custom_target( ${name} )
			ENDIF()

		ENDIF( NOT TARGET ${name})

	ENDIF(NOT arg_ROOT_DIR)

ENDFUNCTION(MIRA_EXTERNAL_PROJECT)
